package de.adorsys.xs2a.adapter.crealogix;

import de.adorsys.xs2a.adapter.api.model.AccountReport;
import de.adorsys.xs2a.adapter.api.model.Balance;
import de.adorsys.xs2a.adapter.api.model.HrefType;
import de.adorsys.xs2a.adapter.api.model.OK200TransactionDetails;
import de.adorsys.xs2a.adapter.api.model.PaymentInitiationWithStatusResponse;
import de.adorsys.xs2a.adapter.api.model.RemittanceInformationStructured;
import de.adorsys.xs2a.adapter.api.model.ReportExchangeRate;
import de.adorsys.xs2a.adapter.api.model.TransactionDetails;
import de.adorsys.xs2a.adapter.api.model.TransactionsResponse200Json;
import de.adorsys.xs2a.adapter.crealogix.model.CrealogixAccountReport;
import de.adorsys.xs2a.adapter.crealogix.model.CrealogixOK200TransactionDetails;
import de.adorsys.xs2a.adapter.crealogix.model.CrealogixPaymentInitiationWithStatusResponse;
import de.adorsys.xs2a.adapter.crealogix.model.CrealogixTransactionDetails;
import de.adorsys.xs2a.adapter.crealogix.model.CrealogixTransactionResponse200Json;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-11-10T16:36:53+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_272 (Azul Systems, Inc.)"
)
public class CrealogixMapperImpl implements CrealogixMapper {

    @Override
    public PaymentInitiationWithStatusResponse toPaymentInitiationWithStatusResponse(CrealogixPaymentInitiationWithStatusResponse value) {
        if ( value == null ) {
            return null;
        }

        PaymentInitiationWithStatusResponse paymentInitiationWithStatusResponse = new PaymentInitiationWithStatusResponse();

        paymentInitiationWithStatusResponse.setEndToEndIdentification( value.getEndToEndIdentification() );
        paymentInitiationWithStatusResponse.setDebtorAccount( value.getDebtorAccount() );
        paymentInitiationWithStatusResponse.setInstructedAmount( value.getInstructedAmount() );
        paymentInitiationWithStatusResponse.setCreditorAccount( value.getCreditorAccount() );
        paymentInitiationWithStatusResponse.setCreditorAgent( value.getCreditorAgent() );
        paymentInitiationWithStatusResponse.setCreditorName( value.getCreditorName() );
        paymentInitiationWithStatusResponse.setCreditorAddress( value.getCreditorAddress() );
        paymentInitiationWithStatusResponse.setRemittanceInformationUnstructured( value.getRemittanceInformationUnstructured() );
        paymentInitiationWithStatusResponse.setTransactionStatus( value.getTransactionStatus() );

        return paymentInitiationWithStatusResponse;
    }

    @Override
    public TransactionsResponse200Json toTransactionsResponse200Json(CrealogixTransactionResponse200Json value) {
        if ( value == null ) {
            return null;
        }

        TransactionsResponse200Json transactionsResponse200Json = new TransactionsResponse200Json();

        transactionsResponse200Json.setAccount( value.getAccount() );
        transactionsResponse200Json.setTransactions( crealogixAccountReportToAccountReport( value.getTransactions() ) );
        List<Balance> list = value.getBalances();
        if ( list != null ) {
            transactionsResponse200Json.setBalances( new ArrayList<Balance>( list ) );
        }
        Map<String, HrefType> map = value.getLinks();
        if ( map != null ) {
            transactionsResponse200Json.setLinks( new HashMap<String, HrefType>( map ) );
        }

        return transactionsResponse200Json;
    }

    @Override
    public OK200TransactionDetails toOK200TransactionDetails(CrealogixOK200TransactionDetails value) {
        if ( value == null ) {
            return null;
        }

        OK200TransactionDetails oK200TransactionDetails = new OK200TransactionDetails();

        oK200TransactionDetails.setTransactionsDetails( crealogixTransactionDetailsToTransactionDetails( value.getTransactionsDetails() ) );

        return oK200TransactionDetails;
    }

    protected TransactionDetails crealogixTransactionDetailsToTransactionDetails(CrealogixTransactionDetails crealogixTransactionDetails) {
        if ( crealogixTransactionDetails == null ) {
            return null;
        }

        TransactionDetails transactionDetails = new TransactionDetails();

        transactionDetails.setTransactionId( crealogixTransactionDetails.getTransactionId() );
        transactionDetails.setEntryReference( crealogixTransactionDetails.getEntryReference() );
        transactionDetails.setEndToEndId( crealogixTransactionDetails.getEndToEndId() );
        transactionDetails.setMandateId( crealogixTransactionDetails.getMandateId() );
        transactionDetails.setCheckId( crealogixTransactionDetails.getCheckId() );
        transactionDetails.setCreditorId( crealogixTransactionDetails.getCreditorId() );
        transactionDetails.setBookingDate( crealogixTransactionDetails.getBookingDate() );
        transactionDetails.setValueDate( crealogixTransactionDetails.getValueDate() );
        transactionDetails.setTransactionAmount( crealogixTransactionDetails.getTransactionAmount() );
        List<ReportExchangeRate> list = crealogixTransactionDetails.getCurrencyExchange();
        if ( list != null ) {
            transactionDetails.setCurrencyExchange( new ArrayList<ReportExchangeRate>( list ) );
        }
        transactionDetails.setCreditorName( crealogixTransactionDetails.getCreditorName() );
        transactionDetails.setCreditorAccount( crealogixTransactionDetails.getCreditorAccount() );
        transactionDetails.setCreditorAgent( crealogixTransactionDetails.getCreditorAgent() );
        transactionDetails.setUltimateCreditor( crealogixTransactionDetails.getUltimateCreditor() );
        transactionDetails.setDebtorName( crealogixTransactionDetails.getDebtorName() );
        transactionDetails.setDebtorAccount( crealogixTransactionDetails.getDebtorAccount() );
        transactionDetails.setDebtorAgent( crealogixTransactionDetails.getDebtorAgent() );
        transactionDetails.setUltimateDebtor( crealogixTransactionDetails.getUltimateDebtor() );
        transactionDetails.setRemittanceInformationUnstructured( crealogixTransactionDetails.getRemittanceInformationUnstructured() );
        List<String> list1 = crealogixTransactionDetails.getRemittanceInformationUnstructuredArray();
        if ( list1 != null ) {
            transactionDetails.setRemittanceInformationUnstructuredArray( new ArrayList<String>( list1 ) );
        }
        transactionDetails.setRemittanceInformationStructured( map( crealogixTransactionDetails.getRemittanceInformationStructured() ) );
        List<RemittanceInformationStructured> list2 = crealogixTransactionDetails.getRemittanceInformationStructuredArray();
        if ( list2 != null ) {
            transactionDetails.setRemittanceInformationStructuredArray( new ArrayList<RemittanceInformationStructured>( list2 ) );
        }
        transactionDetails.setAdditionalInformation( crealogixTransactionDetails.getAdditionalInformation() );
        transactionDetails.setAdditionalInformationStructured( crealogixTransactionDetails.getAdditionalInformationStructured() );
        transactionDetails.setPurposeCode( crealogixTransactionDetails.getPurposeCode() );
        transactionDetails.setBankTransactionCode( crealogixTransactionDetails.getBankTransactionCode() );
        transactionDetails.setProprietaryBankTransactionCode( crealogixTransactionDetails.getProprietaryBankTransactionCode() );
        transactionDetails.setBalanceAfterTransaction( crealogixTransactionDetails.getBalanceAfterTransaction() );
        Map<String, HrefType> map = crealogixTransactionDetails.getLinks();
        if ( map != null ) {
            transactionDetails.setLinks( new HashMap<String, HrefType>( map ) );
        }

        return transactionDetails;
    }

    protected List<TransactionDetails> crealogixTransactionDetailsListToTransactionDetailsList(List<CrealogixTransactionDetails> list) {
        if ( list == null ) {
            return null;
        }

        List<TransactionDetails> list1 = new ArrayList<TransactionDetails>( list.size() );
        for ( CrealogixTransactionDetails crealogixTransactionDetails : list ) {
            list1.add( crealogixTransactionDetailsToTransactionDetails( crealogixTransactionDetails ) );
        }

        return list1;
    }

    protected AccountReport crealogixAccountReportToAccountReport(CrealogixAccountReport crealogixAccountReport) {
        if ( crealogixAccountReport == null ) {
            return null;
        }

        AccountReport accountReport = new AccountReport();

        accountReport.setBooked( crealogixTransactionDetailsListToTransactionDetailsList( crealogixAccountReport.getBooked() ) );
        accountReport.setPending( crealogixTransactionDetailsListToTransactionDetailsList( crealogixAccountReport.getPending() ) );
        Map<String, HrefType> map = crealogixAccountReport.getLinks();
        if ( map != null ) {
            accountReport.setLinks( new HashMap<String, HrefType>( map ) );
        }

        return accountReport;
    }
}
