/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.crealogix;

import de.adorsys.xs2a.adapter.api.RequestHeaders;
import de.adorsys.xs2a.adapter.api.RequestParams;
import de.adorsys.xs2a.adapter.api.Response;
import de.adorsys.xs2a.adapter.api.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.api.link.LinksRewriter;
import de.adorsys.xs2a.adapter.api.model.AccountList;
import de.adorsys.xs2a.adapter.api.model.Aspsp;
import de.adorsys.xs2a.adapter.api.model.CardAccountList;
import de.adorsys.xs2a.adapter.api.model.CardAccountsTransactionsResponse200;
import de.adorsys.xs2a.adapter.api.model.ConsentInformationResponse200Json;
import de.adorsys.xs2a.adapter.api.model.ConsentStatusResponse200;
import de.adorsys.xs2a.adapter.api.model.Consents;
import de.adorsys.xs2a.adapter.api.model.ConsentsResponse201;
import de.adorsys.xs2a.adapter.api.model.OK200AccountDetails;
import de.adorsys.xs2a.adapter.api.model.OK200CardAccountDetails;
import de.adorsys.xs2a.adapter.api.model.OK200TransactionDetails;
import de.adorsys.xs2a.adapter.api.model.ReadAccountBalanceResponse200;
import de.adorsys.xs2a.adapter.api.model.ReadCardAccountBalanceResponse200;
import de.adorsys.xs2a.adapter.api.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.api.model.SelectPsuAuthenticationMethod;
import de.adorsys.xs2a.adapter.api.model.SelectPsuAuthenticationMethodResponse;
import de.adorsys.xs2a.adapter.api.model.StartScaprocessResponse;
import de.adorsys.xs2a.adapter.api.model.TransactionAuthorisation;
import de.adorsys.xs2a.adapter.api.model.TransactionsResponse200Json;
import de.adorsys.xs2a.adapter.api.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.adapter.api.model.UpdatePsuAuthenticationResponse;
import de.adorsys.xs2a.adapter.crealogix.CrealogixMapper;
import de.adorsys.xs2a.adapter.crealogix.CrealogixRequestResponseHandlers;
import de.adorsys.xs2a.adapter.crealogix.model.CrealogixOK200TransactionDetails;
import de.adorsys.xs2a.adapter.crealogix.model.CrealogixTransactionResponse200Json;
import de.adorsys.xs2a.adapter.impl.BaseAccountInformationService;
import java.util.function.Function;
import org.mapstruct.factory.Mappers;

public class CrealogixAccountInformationService
extends BaseAccountInformationService {
    private final CrealogixMapper crealogixMapper = (CrealogixMapper)Mappers.getMapper(CrealogixMapper.class);
    private final CrealogixRequestResponseHandlers requestResponseHandlers;

    public CrealogixAccountInformationService(Aspsp aspsp, HttpClientFactory httpClientFactory, LinksRewriter linksRewriter) {
        super(aspsp, httpClientFactory.getHttpClient(aspsp.getAdapterId()), linksRewriter, httpClientFactory.getHttpClientConfig().getLogSanitizer());
        this.requestResponseHandlers = new CrealogixRequestResponseHandlers(httpClientFactory.getHttpClientConfig().getLogSanitizer());
    }

    public Response<ConsentsResponse201> createConsent(RequestHeaders requestHeaders, RequestParams requestParams, Consents body) {
        return super.createConsent(this.requestHandler(requestHeaders), requestParams, body, Function.identity(), this.requestResponseHandlers.crealogixResponseHandler(ConsentsResponse201.class));
    }

    private RequestHeaders requestHandler(RequestHeaders requestHeaders) {
        return this.requestResponseHandlers.crealogixRequestHandler(requestHeaders);
    }

    public Response<ConsentInformationResponse200Json> getConsentInformation(String consentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getConsentInformation(consentId, this.requestHandler(requestHeaders), requestParams);
    }

    public Response<Void> deleteConsent(String consentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.deleteConsent(consentId, this.requestHandler(requestHeaders), requestParams);
    }

    public Response<ConsentStatusResponse200> getConsentStatus(String consentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getConsentStatus(consentId, this.requestHandler(requestHeaders), requestParams);
    }

    public Response<StartScaprocessResponse> startConsentAuthorisation(String consentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.startConsentAuthorisation(consentId, this.requestHandler(requestHeaders), requestParams);
    }

    public Response<StartScaprocessResponse> startConsentAuthorisation(String consentId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication) {
        return super.startConsentAuthorisation(consentId, this.requestHandler(requestHeaders), requestParams, updatePsuAuthentication);
    }

    public Response<UpdatePsuAuthenticationResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication) {
        return super.updateConsentsPsuData(consentId, authorisationId, this.requestHandler(requestHeaders), requestParams, updatePsuAuthentication);
    }

    public Response<SelectPsuAuthenticationMethodResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, SelectPsuAuthenticationMethod selectPsuAuthenticationMethod) {
        return super.updateConsentsPsuData(consentId, authorisationId, this.requestHandler(requestHeaders), requestParams, selectPsuAuthenticationMethod);
    }

    public Response<ScaStatusResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, TransactionAuthorisation transactionAuthorisation) {
        return super.updateConsentsPsuData(consentId, authorisationId, this.requestHandler(requestHeaders), requestParams, transactionAuthorisation);
    }

    public Response<AccountList> getAccountList(RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getAccountList(this.requestHandler(requestHeaders), requestParams);
    }

    public Response<OK200AccountDetails> readAccountDetails(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.readAccountDetails(accountId, this.requestHandler(requestHeaders), requestParams);
    }

    public Response<TransactionsResponse200Json> getTransactionList(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getTransactionList(accountId, this.requestHandler(requestHeaders), requestParams, CrealogixTransactionResponse200Json.class, this.crealogixMapper::toTransactionsResponse200Json);
    }

    public Response<OK200TransactionDetails> getTransactionDetails(String accountId, String transactionId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getTransactionDetails(accountId, transactionId, this.requestHandler(requestHeaders), requestParams, CrealogixOK200TransactionDetails.class, this.crealogixMapper::toOK200TransactionDetails);
    }

    public Response<String> getTransactionListAsString(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getTransactionListAsString(accountId, this.requestHandler(requestHeaders), requestParams);
    }

    public Response<ScaStatusResponse> getConsentScaStatus(String consentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getConsentScaStatus(consentId, authorisationId, this.requestHandler(requestHeaders), requestParams);
    }

    public Response<ReadAccountBalanceResponse200> getBalances(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getBalances(accountId, this.requestHandler(requestHeaders), requestParams);
    }

    public Response<CardAccountList> getCardAccountList(RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getCardAccountList(this.requestHandler(requestHeaders), requestParams);
    }

    public Response<OK200CardAccountDetails> getCardAccountDetails(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getCardAccountDetails(accountId, this.requestHandler(requestHeaders), requestParams);
    }

    public Response<ReadCardAccountBalanceResponse200> getCardAccountBalances(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getCardAccountBalances(accountId, this.requestHandler(requestHeaders), requestParams);
    }

    public Response<CardAccountsTransactionsResponse200> getCardAccountTransactionList(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getCardAccountTransactionList(accountId, this.requestHandler(requestHeaders), requestParams);
    }
}

