package de.adorsys.xs2a.adapter.crealogix;

import de.adorsys.xs2a.adapter.api.model.AccountReport;
import de.adorsys.xs2a.adapter.api.model.Balance;
import de.adorsys.xs2a.adapter.api.model.HrefType;
import de.adorsys.xs2a.adapter.api.model.OK200TransactionDetails;
import de.adorsys.xs2a.adapter.api.model.PaymentInitiationWithStatusResponse;
import de.adorsys.xs2a.adapter.api.model.RemittanceInformationStructured;
import de.adorsys.xs2a.adapter.api.model.ReportExchangeRate;
import de.adorsys.xs2a.adapter.api.model.TokenResponse;
import de.adorsys.xs2a.adapter.api.model.TransactionDetailsBody;
import de.adorsys.xs2a.adapter.api.model.Transactions;
import de.adorsys.xs2a.adapter.api.model.TransactionsResponse200Json;
import de.adorsys.xs2a.adapter.crealogix.model.CrealogixAccountReport;
import de.adorsys.xs2a.adapter.crealogix.model.CrealogixOK200TransactionDetails;
import de.adorsys.xs2a.adapter.crealogix.model.CrealogixPaymentInitiationWithStatusResponse;
import de.adorsys.xs2a.adapter.crealogix.model.CrealogixTransactionDetails;
import de.adorsys.xs2a.adapter.crealogix.model.CrealogixTransactionResponse200Json;
import de.adorsys.xs2a.adapter.crealogix.model.CrealogixValidationResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-12-02T19:49:41+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.13 (Azul Systems, Inc.)"
)
public class CrealogixMapperImpl implements CrealogixMapper {

    @Override
    public PaymentInitiationWithStatusResponse toPaymentInitiationWithStatusResponse(CrealogixPaymentInitiationWithStatusResponse value) {
        if ( value == null ) {
            return null;
        }

        PaymentInitiationWithStatusResponse paymentInitiationWithStatusResponse = new PaymentInitiationWithStatusResponse();

        paymentInitiationWithStatusResponse.setEndToEndIdentification( value.getEndToEndIdentification() );
        paymentInitiationWithStatusResponse.setDebtorAccount( value.getDebtorAccount() );
        paymentInitiationWithStatusResponse.setInstructedAmount( value.getInstructedAmount() );
        paymentInitiationWithStatusResponse.setCreditorAccount( value.getCreditorAccount() );
        paymentInitiationWithStatusResponse.setCreditorAgent( value.getCreditorAgent() );
        paymentInitiationWithStatusResponse.setCreditorName( value.getCreditorName() );
        paymentInitiationWithStatusResponse.setCreditorAddress( value.getCreditorAddress() );
        paymentInitiationWithStatusResponse.setRemittanceInformationUnstructured( value.getRemittanceInformationUnstructured() );
        paymentInitiationWithStatusResponse.setTransactionStatus( value.getTransactionStatus() );

        return paymentInitiationWithStatusResponse;
    }

    @Override
    public TransactionsResponse200Json toTransactionsResponse200Json(CrealogixTransactionResponse200Json value) {
        if ( value == null ) {
            return null;
        }

        TransactionsResponse200Json transactionsResponse200Json = new TransactionsResponse200Json();

        transactionsResponse200Json.setAccount( value.getAccount() );
        transactionsResponse200Json.setTransactions( crealogixAccountReportToAccountReport( value.getTransactions() ) );
        List<Balance> list = value.getBalances();
        if ( list != null ) {
            transactionsResponse200Json.setBalances( new ArrayList<Balance>( list ) );
        }
        Map<String, HrefType> map = value.getLinks();
        if ( map != null ) {
            transactionsResponse200Json.setLinks( new HashMap<String, HrefType>( map ) );
        }

        return transactionsResponse200Json;
    }

    @Override
    public OK200TransactionDetails toOK200TransactionDetails(CrealogixOK200TransactionDetails value) {
        if ( value == null ) {
            return null;
        }

        OK200TransactionDetails oK200TransactionDetails = new OK200TransactionDetails();

        oK200TransactionDetails.setTransactionsDetails( toTransactionDetailsBody( value.getTransactionsDetails() ) );

        return oK200TransactionDetails;
    }

    @Override
    public Transactions toTransactions(CrealogixTransactionDetails value) {
        if ( value == null ) {
            return null;
        }

        Transactions transactions = new Transactions();

        transactions.setTransactionId( value.getTransactionId() );
        transactions.setEntryReference( value.getEntryReference() );
        transactions.setEndToEndId( value.getEndToEndId() );
        transactions.setMandateId( value.getMandateId() );
        transactions.setCheckId( value.getCheckId() );
        transactions.setCreditorId( value.getCreditorId() );
        transactions.setBookingDate( value.getBookingDate() );
        transactions.setValueDate( value.getValueDate() );
        transactions.setTransactionAmount( value.getTransactionAmount() );
        List<ReportExchangeRate> list = value.getCurrencyExchange();
        if ( list != null ) {
            transactions.setCurrencyExchange( new ArrayList<ReportExchangeRate>( list ) );
        }
        transactions.setCreditorName( value.getCreditorName() );
        transactions.setCreditorAccount( value.getCreditorAccount() );
        transactions.setCreditorAgent( value.getCreditorAgent() );
        transactions.setUltimateCreditor( value.getUltimateCreditor() );
        transactions.setDebtorName( value.getDebtorName() );
        transactions.setDebtorAccount( value.getDebtorAccount() );
        transactions.setDebtorAgent( value.getDebtorAgent() );
        transactions.setUltimateDebtor( value.getUltimateDebtor() );
        transactions.setRemittanceInformationUnstructured( value.getRemittanceInformationUnstructured() );
        List<String> list1 = value.getRemittanceInformationUnstructuredArray();
        if ( list1 != null ) {
            transactions.setRemittanceInformationUnstructuredArray( new ArrayList<String>( list1 ) );
        }
        transactions.setRemittanceInformationStructured( map( value.getRemittanceInformationStructured() ) );
        List<RemittanceInformationStructured> list2 = value.getRemittanceInformationStructuredArray();
        if ( list2 != null ) {
            transactions.setRemittanceInformationStructuredArray( new ArrayList<RemittanceInformationStructured>( list2 ) );
        }
        transactions.setAdditionalInformation( value.getAdditionalInformation() );
        transactions.setAdditionalInformationStructured( value.getAdditionalInformationStructured() );
        transactions.setPurposeCode( value.getPurposeCode() );
        transactions.setBankTransactionCode( value.getBankTransactionCode() );
        transactions.setProprietaryBankTransactionCode( value.getProprietaryBankTransactionCode() );
        transactions.setBalanceAfterTransaction( value.getBalanceAfterTransaction() );
        Map<String, HrefType> map = value.getLinks();
        if ( map != null ) {
            transactions.setLinks( new HashMap<String, HrefType>( map ) );
        }

        return transactions;
    }

    @Override
    public TokenResponse toTokenResponse(CrealogixValidationResponse value) {
        if ( value == null ) {
            return null;
        }

        TokenResponse tokenResponse = new TokenResponse();

        tokenResponse.setAccessToken( value.getAccessToken() );

        return tokenResponse;
    }

    @Override
    public TransactionDetailsBody toTransactionDetailsBody(CrealogixTransactionDetails value) {
        if ( value == null ) {
            return null;
        }

        TransactionDetailsBody transactionDetailsBody = new TransactionDetailsBody();

        transactionDetailsBody.setTransactionDetails( toTransactions(value) );

        return transactionDetailsBody;
    }

    protected List<Transactions> crealogixTransactionDetailsListToTransactionsList(List<CrealogixTransactionDetails> list) {
        if ( list == null ) {
            return null;
        }

        List<Transactions> list1 = new ArrayList<Transactions>( list.size() );
        for ( CrealogixTransactionDetails crealogixTransactionDetails : list ) {
            list1.add( toTransactions( crealogixTransactionDetails ) );
        }

        return list1;
    }

    protected AccountReport crealogixAccountReportToAccountReport(CrealogixAccountReport crealogixAccountReport) {
        if ( crealogixAccountReport == null ) {
            return null;
        }

        AccountReport accountReport = new AccountReport();

        accountReport.setBooked( crealogixTransactionDetailsListToTransactionsList( crealogixAccountReport.getBooked() ) );
        accountReport.setPending( crealogixTransactionDetailsListToTransactionsList( crealogixAccountReport.getPending() ) );
        Map<String, HrefType> map = crealogixAccountReport.getLinks();
        if ( map != null ) {
            accountReport.setLinks( new HashMap<String, HrefType>( map ) );
        }

        return accountReport;
    }
}
