/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.crealogix;

import de.adorsys.xs2a.adapter.api.RequestHeaders;
import de.adorsys.xs2a.adapter.api.RequestParams;
import de.adorsys.xs2a.adapter.api.Response;
import de.adorsys.xs2a.adapter.api.http.HttpClientConfig;
import de.adorsys.xs2a.adapter.api.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.api.link.LinksRewriter;
import de.adorsys.xs2a.adapter.api.model.Aspsp;
import de.adorsys.xs2a.adapter.api.model.Authorisations;
import de.adorsys.xs2a.adapter.api.model.PaymentInitationRequestResponse201;
import de.adorsys.xs2a.adapter.api.model.PaymentInitiationStatusResponse200Json;
import de.adorsys.xs2a.adapter.api.model.PaymentInitiationWithStatusResponse;
import de.adorsys.xs2a.adapter.api.model.PaymentProduct;
import de.adorsys.xs2a.adapter.api.model.PaymentService;
import de.adorsys.xs2a.adapter.api.model.PeriodicPaymentInitiationMultipartBody;
import de.adorsys.xs2a.adapter.api.model.PeriodicPaymentInitiationWithStatusResponse;
import de.adorsys.xs2a.adapter.api.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.api.model.SelectPsuAuthenticationMethod;
import de.adorsys.xs2a.adapter.api.model.SelectPsuAuthenticationMethodResponse;
import de.adorsys.xs2a.adapter.api.model.StartScaprocessResponse;
import de.adorsys.xs2a.adapter.api.model.TransactionAuthorisation;
import de.adorsys.xs2a.adapter.api.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.adapter.api.model.UpdatePsuAuthenticationResponse;
import de.adorsys.xs2a.adapter.crealogix.CrealogixMapper;
import de.adorsys.xs2a.adapter.crealogix.CrealogixRequestResponseHandlers;
import de.adorsys.xs2a.adapter.crealogix.model.CrealogixPaymentInitiationWithStatusResponse;
import de.adorsys.xs2a.adapter.impl.BasePaymentInitiationService;
import java.util.function.Function;
import org.mapstruct.factory.Mappers;

public class CrealogixPaymentInitiationService
extends BasePaymentInitiationService {
    private final CrealogixMapper mapper = (CrealogixMapper)Mappers.getMapper(CrealogixMapper.class);
    private final CrealogixRequestResponseHandlers requestResponseHandlers;

    public CrealogixPaymentInitiationService(Aspsp aspsp, HttpClientFactory httpClientFactory, LinksRewriter linksRewriter) {
        super(aspsp, httpClientFactory.getHttpClient(aspsp.getAdapterId()), linksRewriter, httpClientFactory.getHttpClientConfig().getLogSanitizer());
        HttpClientConfig config = httpClientFactory.getHttpClientConfig();
        this.requestResponseHandlers = new CrealogixRequestResponseHandlers(config.getLogSanitizer());
    }

    public Response<PaymentInitationRequestResponse201> initiatePayment(PaymentService paymentService, PaymentProduct paymentProduct, RequestHeaders requestHeaders, RequestParams requestParams, Object body) {
        return super.initiatePayment(paymentService, paymentProduct, body, this.requestHandler(requestHeaders), requestParams, Function.identity(), this.requestResponseHandlers.crealogixResponseHandler(PaymentInitationRequestResponse201.class));
    }

    public Response<PaymentInitiationWithStatusResponse> getSinglePaymentInformation(PaymentProduct paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getPaymentInformation(PaymentService.PAYMENTS, paymentProduct, paymentId, this.requestHandler(requestHeaders), requestParams, this.requestResponseHandlers.jsonResponseHandler(CrealogixPaymentInitiationWithStatusResponse.class)).map(this.mapper::toPaymentInitiationWithStatusResponse);
    }

    public Response<PeriodicPaymentInitiationWithStatusResponse> getPeriodicPaymentInformation(PaymentProduct paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getPeriodicPaymentInformation(paymentProduct, paymentId, this.requestHandler(requestHeaders), requestParams);
    }

    public Response<PeriodicPaymentInitiationMultipartBody> getPeriodicPain001PaymentInformation(PaymentProduct paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getPeriodicPain001PaymentInformation(paymentProduct, paymentId, this.requestHandler(requestHeaders), requestParams);
    }

    public Response<String> getPaymentInformationAsString(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getPaymentInformationAsString(paymentService, paymentProduct, paymentId, this.requestHandler(requestHeaders), requestParams);
    }

    public Response<ScaStatusResponse> getPaymentInitiationScaStatus(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getPaymentInitiationScaStatus(paymentService, paymentProduct, paymentId, authorisationId, this.requestHandler(requestHeaders), requestParams);
    }

    public Response<PaymentInitiationStatusResponse200Json> getPaymentInitiationStatus(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getPaymentInitiationStatus(paymentService, paymentProduct, paymentId, this.requestHandler(requestHeaders), requestParams);
    }

    public Response<String> getPaymentInitiationStatusAsString(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getPaymentInitiationStatusAsString(paymentService, paymentProduct, paymentId, this.requestHandler(requestHeaders), requestParams);
    }

    public Response<Authorisations> getPaymentInitiationAuthorisation(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getPaymentInitiationAuthorisation(paymentService, paymentProduct, paymentId, this.requestHandler(requestHeaders), requestParams);
    }

    public Response<StartScaprocessResponse> startPaymentAuthorisation(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.startPaymentAuthorisation(paymentService, paymentProduct, paymentId, this.requestHandler(requestHeaders), requestParams);
    }

    public Response<StartScaprocessResponse> startPaymentAuthorisation(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication) {
        return super.startPaymentAuthorisation(paymentService, paymentProduct, paymentId, this.requestHandler(requestHeaders), requestParams, updatePsuAuthentication);
    }

    public Response<UpdatePsuAuthenticationResponse> updatePaymentPsuData(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication) {
        return super.updatePaymentPsuData(paymentService, paymentProduct, paymentId, authorisationId, this.requestHandler(requestHeaders), requestParams, updatePsuAuthentication);
    }

    public Response<SelectPsuAuthenticationMethodResponse> updatePaymentPsuData(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, SelectPsuAuthenticationMethod selectPsuAuthenticationMethod) {
        return super.updatePaymentPsuData(paymentService, paymentProduct, paymentId, authorisationId, this.requestHandler(requestHeaders), requestParams, selectPsuAuthenticationMethod);
    }

    public Response<ScaStatusResponse> updatePaymentPsuData(PaymentService paymentService, PaymentProduct paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, TransactionAuthorisation transactionAuthorisation) {
        return super.updatePaymentPsuData(paymentService, paymentProduct, paymentId, authorisationId, this.requestHandler(requestHeaders), requestParams, transactionAuthorisation);
    }

    private RequestHeaders requestHandler(RequestHeaders requestHeaders) {
        return this.requestResponseHandlers.crealogixRequestHandler(requestHeaders);
    }
}

