/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.crealogix;

import de.adorsys.xs2a.adapter.api.EmbeddedPreAuthorisationService;
import de.adorsys.xs2a.adapter.api.RequestHeaders;
import de.adorsys.xs2a.adapter.api.Response;
import de.adorsys.xs2a.adapter.api.config.AdapterConfig;
import de.adorsys.xs2a.adapter.api.exception.AccessTokenException;
import de.adorsys.xs2a.adapter.api.http.HttpClient;
import de.adorsys.xs2a.adapter.api.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.api.http.HttpLogSanitizer;
import de.adorsys.xs2a.adapter.api.model.Aspsp;
import de.adorsys.xs2a.adapter.api.model.EmbeddedPreAuthorisationRequest;
import de.adorsys.xs2a.adapter.api.model.TokenResponse;
import de.adorsys.xs2a.adapter.crealogix.CrealogixClient;
import de.adorsys.xs2a.adapter.crealogix.CrealogixMapper;
import de.adorsys.xs2a.adapter.crealogix.model.CrealogixValidationResponse;
import de.adorsys.xs2a.adapter.impl.http.JacksonObjectMapper;
import de.adorsys.xs2a.adapter.impl.http.JsonMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrealogixEmbeddedPreAuthorisationService
implements EmbeddedPreAuthorisationService {
    private final Logger logger = LoggerFactory.getLogger(CrealogixEmbeddedPreAuthorisationService.class);
    private final CrealogixMapper mapper = (CrealogixMapper)Mappers.getMapper(CrealogixMapper.class);
    public static final String PSD2_TOKEN_URL = ".psd2_token.url";
    private static final String CREDENTIALS_JSON_BODY = "{\"username\":\"%s\",\"password\":\"%s\"}";
    private final Aspsp aspsp;
    private final HttpClient httpClient;
    private final HttpLogSanitizer logSanitizer;
    private final JsonMapper jsonMapper;
    private final String psd2TokenUrl;

    public CrealogixEmbeddedPreAuthorisationService(CrealogixClient crealogixClient, Aspsp aspsp, HttpClientFactory httpClientFactory) {
        this.aspsp = aspsp;
        this.httpClient = httpClientFactory.getHttpClient(aspsp.getAdapterId());
        this.logSanitizer = httpClientFactory.getHttpClientConfig().getLogSanitizer();
        this.jsonMapper = new JacksonObjectMapper();
        String prefix = crealogixClient.getPrefix();
        this.psd2TokenUrl = AdapterConfig.readProperty((String)(prefix + PSD2_TOKEN_URL), (String)"");
        if (StringUtils.isEmpty((CharSequence)this.psd2TokenUrl)) {
            throw new AccessTokenException("PSD2 Token URL is not provided");
        }
    }

    public TokenResponse getToken(EmbeddedPreAuthorisationRequest request, RequestHeaders requestHeaders) {
        String psd2AuthorisationToken = this.retrievePsd2AuthorisationToken(request.getUsername(), request.getPassword());
        TokenResponse tokenResponse = new TokenResponse();
        tokenResponse.setAccessToken(psd2AuthorisationToken);
        return tokenResponse;
    }

    private String retrievePsd2AuthorisationToken(String username, String password) {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("Content-Type", "application/json");
        Response response = this.httpClient.post(CrealogixEmbeddedPreAuthorisationService.adjustIdpUrl(this.aspsp.getIdpUrl()) + this.psd2TokenUrl).jsonBody(String.format(CREDENTIALS_JSON_BODY, username, password)).headers(headers).send(this.responseHandler(CrealogixValidationResponse.class)).map(this.mapper::toTokenResponse);
        return ((TokenResponse)response.getBody()).getAccessToken();
    }

    <T> HttpClient.ResponseHandler<T> responseHandler(Class<T> tClass) {
        return (statusCode, responseBody, responseHeaders) -> {
            if (this.isSuccess(statusCode)) {
                return this.jsonMapper.readValue(responseBody, tClass);
            }
            String sanitizedResponse = this.logSanitizer.sanitize(this.toString(responseBody));
            this.logger.error("Failed to retrieve Token. Status code: {}\nBank response: {}", (Object)statusCode, (Object)sanitizedResponse);
            throw new AccessTokenException("Can't retrieve access token by provided credentials", Integer.valueOf(statusCode), sanitizedResponse, Boolean.valueOf(true));
        };
    }

    private String toString(InputStream inputStream) {
        try {
            return IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean isSuccess(int statusCode) {
        return Response.Status.Family.SUCCESSFUL.equals((Object)Response.Status.Family.familyOf((int)statusCode));
    }

    private static String adjustIdpUrl(String idpUrl) {
        return idpUrl.endsWith("/") ? idpUrl.substring(0, idpUrl.length() - 1) : idpUrl;
    }
}

