/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.crealogix;

import de.adorsys.xs2a.adapter.api.RequestHeaders;
import de.adorsys.xs2a.adapter.api.ResponseHeaders;
import de.adorsys.xs2a.adapter.api.exception.ErrorResponseException;
import de.adorsys.xs2a.adapter.api.exception.PreAuthorisationException;
import de.adorsys.xs2a.adapter.api.http.HttpClient;
import de.adorsys.xs2a.adapter.api.http.HttpLogSanitizer;
import de.adorsys.xs2a.adapter.api.model.ErrorResponse;
import de.adorsys.xs2a.adapter.api.model.HrefType;
import de.adorsys.xs2a.adapter.api.model.MessageCode;
import de.adorsys.xs2a.adapter.api.model.TppMessage;
import de.adorsys.xs2a.adapter.api.model.TppMessageCategory;
import de.adorsys.xs2a.adapter.impl.http.ResponseHandlers;
import de.adorsys.xs2a.adapter.impl.security.AccessTokenException;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;

public class CrealogixRequestResponseHandlers {
    public static final String REQUEST_ERROR_MESSAGE = "authorization header is missing, embedded pre-authorization may be needed";
    public static final String RESPONSE_ERROR_MESSAGE = "embedded pre-authorisation needed";
    public static final String INVALID_CREDENTIALS_TYPE_MESSAGE = "Authorization header credentials type is invalid. 'Bearer' type is expected";
    private static final String BEARER = "Bearer ";
    private final ResponseHandlers responseHandlers;

    public CrealogixRequestResponseHandlers(HttpLogSanitizer logSanitizer) {
        this.responseHandlers = new ResponseHandlers(logSanitizer);
    }

    public RequestHeaders crealogixRequestHandler(RequestHeaders requestHeaders) {
        return Stream.of(requestHeaders).map(RequestHeaders::toMap).map(this::checkAuthorizationHeader).map(this::validateCredentialsType).map(this::mapToPsd2Authorisation).map(RequestHeaders::fromMap).findFirst().orElse(requestHeaders);
    }

    private Map<String, String> mapToPsd2Authorisation(Map<String, String> requestHeaders) {
        String token = requestHeaders.remove("Authorization");
        requestHeaders.put("PSD2-AUTHORIZATION", token);
        return requestHeaders;
    }

    private Map<String, String> validateCredentialsType(Map<String, String> requestHeaders) {
        String token = requestHeaders.get("Authorization");
        if (!token.startsWith(BEARER)) {
            throw new AccessTokenException(INVALID_CREDENTIALS_TYPE_MESSAGE);
        }
        return requestHeaders;
    }

    private Map<String, String> checkAuthorizationHeader(Map<String, String> requestHeaders) {
        if (!requestHeaders.containsKey("Authorization")) {
            throw new PreAuthorisationException(CrealogixRequestResponseHandlers.getErrorResponse(REQUEST_ERROR_MESSAGE), REQUEST_ERROR_MESSAGE);
        }
        return requestHeaders;
    }

    public <T> HttpClient.ResponseHandler<T> crealogixResponseHandler(Class<T> tClass) {
        return (statusCode, responseBody, responseHeaders) -> {
            if (statusCode == 401 || statusCode == 403) {
                throw new ErrorResponseException(401, ResponseHeaders.emptyResponseHeaders(), CrealogixRequestResponseHandlers.getErrorResponse(), RESPONSE_ERROR_MESSAGE);
            }
            return this.responseHandlers.jsonResponseHandler(tClass).apply(statusCode, responseBody, responseHeaders);
        };
    }

    public <T> HttpClient.ResponseHandler<T> jsonResponseHandler(Class<T> tClass) {
        return this.responseHandlers.jsonResponseHandler(tClass);
    }

    private static ErrorResponse getErrorResponse(String message) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setLinks(Collections.singletonMap("embeddedPreAuth", CrealogixRequestResponseHandlers.getHrefType()));
        errorResponse.setTppMessages(Collections.singletonList(CrealogixRequestResponseHandlers.getTppMessage(message)));
        return errorResponse;
    }

    private static ErrorResponse getErrorResponse() {
        return CrealogixRequestResponseHandlers.getErrorResponse(RESPONSE_ERROR_MESSAGE);
    }

    private static HrefType getHrefType() {
        HrefType hrefType = new HrefType();
        hrefType.setHref("/v1/embedded-pre-auth/token");
        return hrefType;
    }

    private static TppMessage getTppMessage(String message) {
        TppMessage tppMessage = new TppMessage();
        tppMessage.setCategory(TppMessageCategory.ERROR);
        tppMessage.setCode(MessageCode.TOKEN_UNKNOWN);
        tppMessage.setText(message);
        return tppMessage;
    }
}

