/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.commerzbank.service;

import de.adorsys.xs2a.adapter.adapter.BaseOauth2Service;
import de.adorsys.xs2a.adapter.adapter.CertificateSubjectClientIdOauth2Service;
import de.adorsys.xs2a.adapter.adapter.PkceOauth2Service;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.StringUri;
import de.adorsys.xs2a.adapter.http.UriBuilder;
import de.adorsys.xs2a.adapter.service.Oauth2Service;
import de.adorsys.xs2a.adapter.service.PkceOauth2Extension;
import de.adorsys.xs2a.adapter.service.Pkcs12KeyStore;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import de.adorsys.xs2a.adapter.service.model.TokenResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Map;

public class CommerzbankOauth2Service
implements Oauth2Service,
PkceOauth2Extension {
    private final Oauth2Service oauth2Service;
    private final String baseUrl;

    private CommerzbankOauth2Service(Oauth2Service oauth2Service, String baseUrl) {
        this.oauth2Service = oauth2Service;
        this.baseUrl = baseUrl;
    }

    public static CommerzbankOauth2Service create(Aspsp aspsp, HttpClient httpClient, Pkcs12KeyStore keyStore) {
        String baseUrl = aspsp.getIdpUrl() != null ? aspsp.getIdpUrl() : aspsp.getUrl();
        BaseOauth2Service baseOauth2Service = new BaseOauth2Service(aspsp, httpClient);
        CertificateSubjectClientIdOauth2Service clientIdOauth2Service = new CertificateSubjectClientIdOauth2Service((Oauth2Service)baseOauth2Service, keyStore);
        return new CommerzbankOauth2Service((Oauth2Service)new PkceOauth2Service((Oauth2Service)clientIdOauth2Service), baseUrl);
    }

    public URI getAuthorizationRequestUri(Map<String, String> headers, Oauth2Service.Parameters parameters) throws IOException {
        parameters.setAuthorizationEndpoint(parameters.removeScaOAuthLink());
        return UriBuilder.fromUri((URI)this.oauth2Service.getAuthorizationRequestUri(headers, parameters)).queryParam("scope", this.scope(parameters)).build();
    }

    private String scope(Oauth2Service.Parameters parameters) {
        if (parameters.getConsentId() != null) {
            return "AIS:" + parameters.getConsentId();
        }
        return null;
    }

    public TokenResponse getToken(Map<String, String> headers, Oauth2Service.Parameters parameters) throws IOException {
        parameters.removeScaOAuthLink();
        parameters.setTokenEndpoint(StringUri.fromElements((String[])new String[]{this.baseUrl, "/v1/token"}));
        return this.oauth2Service.getToken(headers, parameters);
    }
}

