package de.adorsys.xs2a.adapter.commerzbank.service.mapper;

import de.adorsys.xs2a.adapter.commerzbank.service.model.CommerzbankBalance;
import de.adorsys.xs2a.adapter.commerzbank.service.model.CommerzbankTransactionsReport;
import de.adorsys.xs2a.adapter.service.model.Balance;
import de.adorsys.xs2a.adapter.service.model.Link;
import de.adorsys.xs2a.adapter.service.model.TransactionsReport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-02-11T08:54:57+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_242 (Azul Systems, Inc.)"
)
public class TransactionsReportMapperImpl implements TransactionsReportMapper {

    @Override
    public TransactionsReport toTransactionsReport(CommerzbankTransactionsReport report) {
        if ( report == null ) {
            return null;
        }

        TransactionsReport transactionsReport = new TransactionsReport();

        transactionsReport.setAccountReference( report.getAccountReference() );
        transactionsReport.setTransactions( report.getTransactions() );
        transactionsReport.setBalances( commerzbankBalanceListToBalanceList( report.getBalances() ) );
        Map<String, Link> map = report.getLinks();
        if ( map != null ) {
            transactionsReport.setLinks( new HashMap<String, Link>( map ) );
        }

        return transactionsReport;
    }

    protected Balance commerzbankBalanceToBalance(CommerzbankBalance commerzbankBalance) {
        if ( commerzbankBalance == null ) {
            return null;
        }

        Balance balance = new Balance();

        balance.setBalanceAmount( commerzbankBalance.getBalanceAmount() );
        balance.setBalanceType( commerzbankBalance.getBalanceType() );
        balance.setLastChangeDateTime( toOffsetDateTime( commerzbankBalance.getLastChangeDateTime() ) );
        balance.setReferenceDate( commerzbankBalance.getReferenceDate() );
        balance.setLastCommittedTransaction( commerzbankBalance.getLastCommittedTransaction() );

        return balance;
    }

    protected List<Balance> commerzbankBalanceListToBalanceList(List<CommerzbankBalance> list) {
        if ( list == null ) {
            return null;
        }

        List<Balance> list1 = new ArrayList<Balance>( list.size() );
        for ( CommerzbankBalance commerzbankBalance : list ) {
            list1.add( commerzbankBalanceToBalance( commerzbankBalance ) );
        }

        return list1;
    }
}
