/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.commerzbank.service.mapper;

import de.adorsys.xs2a.adapter.commerzbank.service.mapper.TransactionsReportMapper;
import de.adorsys.xs2a.adapter.commerzbank.service.model.CommerzbankBalance;
import de.adorsys.xs2a.adapter.commerzbank.service.model.CommerzbankTransactionsReport;
import de.adorsys.xs2a.adapter.service.model.Balance;
import de.adorsys.xs2a.adapter.service.model.Link;
import de.adorsys.xs2a.adapter.service.model.TransactionsReport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactionsReportMapperImpl
implements TransactionsReportMapper {
    @Override
    public TransactionsReport toTransactionsReport(CommerzbankTransactionsReport report) {
        if (report == null) {
            return null;
        }
        TransactionsReport transactionsReport = new TransactionsReport();
        transactionsReport.setAccountReference(report.getAccountReference());
        transactionsReport.setTransactions(report.getTransactions());
        transactionsReport.setBalances(this.commerzbankBalanceListToBalanceList(report.getBalances()));
        Map<String, Link> map = report.getLinks();
        if (map != null) {
            transactionsReport.setLinks(new HashMap<String, Link>(map));
        }
        return transactionsReport;
    }

    protected Balance commerzbankBalanceToBalance(CommerzbankBalance commerzbankBalance) {
        if (commerzbankBalance == null) {
            return null;
        }
        Balance balance = new Balance();
        balance.setBalanceAmount(commerzbankBalance.getBalanceAmount());
        balance.setBalanceType(commerzbankBalance.getBalanceType());
        balance.setLastChangeDateTime(this.toOffsetDateTime(commerzbankBalance.getLastChangeDateTime()));
        balance.setReferenceDate(commerzbankBalance.getReferenceDate());
        balance.setLastCommittedTransaction(commerzbankBalance.getLastCommittedTransaction());
        return balance;
    }

    protected List<Balance> commerzbankBalanceListToBalanceList(List<CommerzbankBalance> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Balance> list1 = new ArrayList<Balance>(list.size());
        for (CommerzbankBalance commerzbankBalance : list) {
            list1.add(this.commerzbankBalanceToBalance(commerzbankBalance));
        }
        return list1;
    }
}

