/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.commerzbank.service;

import de.adorsys.xs2a.adapter.adapter.AbstractService;
import de.adorsys.xs2a.adapter.adapter.mapper.TokenResponseMapper;
import de.adorsys.xs2a.adapter.adapter.model.OauthToken;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.ResponseHandlers;
import de.adorsys.xs2a.adapter.http.StringUri;
import de.adorsys.xs2a.adapter.service.Oauth2Service;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.model.TokenResponse;
import java.net.URI;
import java.util.Map;
import org.mapstruct.factory.Mappers;

public class CommerzbankOauth2Service
extends AbstractService
implements Oauth2Service {
    private final TokenResponseMapper tokenResponseMapper = (TokenResponseMapper)Mappers.getMapper(TokenResponseMapper.class);
    private final String baseUrl;

    public CommerzbankOauth2Service(String baseUrl, HttpClient httpClient) {
        super(httpClient);
        this.baseUrl = baseUrl;
    }

    public URI getAuthorizationRequestUri(Map<String, String> headers, Oauth2Service.Parameters parameters) {
        throw new UnsupportedOperationException();
    }

    public TokenResponse getToken(Map<String, String> headers, Oauth2Service.Parameters parameters) {
        String url = StringUri.fromElements((String[])new String[]{this.baseUrl, "/v1/token"});
        parameters.setCodeVerifier("sha256");
        Response response = this.httpClient.post(url).urlEncodedBody(parameters.asMap()).send(ResponseHandlers.jsonResponseHandler(OauthToken.class));
        return this.tokenResponseMapper.map((OauthToken)response.getBody());
    }
}

