/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.adorsys.service;

import de.adorsys.xs2a.adapter.adapter.mapper.TokenResponseMapper;
import de.adorsys.xs2a.adapter.adapter.model.OauthToken;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.ResponseHandlers;
import de.adorsys.xs2a.adapter.http.StringUri;
import de.adorsys.xs2a.adapter.service.Oauth2Service;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import de.adorsys.xs2a.adapter.service.model.TokenResponse;
import de.adorsys.xs2a.adapter.service.oauth.Oauth2Api;
import de.adorsys.xs2a.adapter.validation.Validation;
import de.adorsys.xs2a.adapter.validation.ValidationError;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.factory.Mappers;

public class AdorsysIntegOauth2Service
implements Oauth2Service {
    private static final String SCA_OAUTH_LINK_MISSING_ERROR_MESSAGE = "SCA OAuth link is missing or has a wrong format: it has to be either provided as a request parameter or preconfigured for the current ASPSP";
    private final Aspsp aspsp;
    private final HttpClient httpClient;
    private final Oauth2Api oauth2Api;
    private final TokenResponseMapper tokenResponseMapper = (TokenResponseMapper)Mappers.getMapper(TokenResponseMapper.class);

    public AdorsysIntegOauth2Service(Aspsp aspsp, HttpClient httpClient, Oauth2Api oauth2Api) {
        this.aspsp = aspsp;
        this.httpClient = httpClient;
        this.oauth2Api = oauth2Api;
    }

    public URI getAuthorizationRequestUri(Map<String, String> headers, Oauth2Service.Parameters parameters) {
        Validation.requireValid(this.validateGetAuthorizationRequestUri(headers, parameters));
        String scaOAuthUrl = this.getScaOAuthUrl(parameters);
        String authorisationUri = this.oauth2Api.getAuthorisationUri(scaOAuthUrl);
        authorisationUri = StringUri.appendQueryParam((String)authorisationUri, (String)"redirect_uri", (String)parameters.getRedirectUri());
        return URI.create(authorisationUri);
    }

    public List<ValidationError> validateGetAuthorizationRequestUri(Map<String, String> headers, Oauth2Service.Parameters parameters) {
        if (StringUtils.isBlank((CharSequence)this.getScaOAuthUrl(parameters))) {
            return Collections.singletonList(new ValidationError(ValidationError.Code.REQUIRED, "sca_oauth_link", SCA_OAUTH_LINK_MISSING_ERROR_MESSAGE));
        }
        return Collections.emptyList();
    }

    public TokenResponse getToken(Map<String, String> headers, Oauth2Service.Parameters parameters) {
        Validation.requireValid(this.validateGetToken(headers, parameters));
        String scaOAuthUrl = this.getScaOAuthUrl(parameters);
        String url = StringUri.withQuery((String)this.oauth2Api.getTokenUri(scaOAuthUrl), (String)"code", (String)parameters.getAuthorizationCode());
        Response response = this.httpClient.post(url).send(ResponseHandlers.jsonResponseHandler(OauthToken.class));
        return this.tokenResponseMapper.map((OauthToken)response.getBody());
    }

    public List<ValidationError> validateGetToken(Map<String, String> headers, Oauth2Service.Parameters parameters) {
        String scaOAuthUrl = this.getScaOAuthUrl(parameters);
        if (StringUtils.isBlank((CharSequence)scaOAuthUrl) || !StringUri.containsProtocol((String)scaOAuthUrl)) {
            return Collections.singletonList(new ValidationError(ValidationError.Code.REQUIRED, "sca_oauth_link", SCA_OAUTH_LINK_MISSING_ERROR_MESSAGE));
        }
        return Collections.emptyList();
    }

    private String getScaOAuthUrl(Oauth2Service.Parameters parameters) {
        String scaOAuthLinkParam = parameters.getScaOAuthLink();
        if (StringUtils.isNotBlank((CharSequence)scaOAuthLinkParam)) {
            return StringUri.decode((String)scaOAuthLinkParam);
        }
        return this.aspsp.getIdpUrl();
    }
}

