/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.adorsys.service.provider;

import de.adorsys.xs2a.adapter.http.Request;
import de.adorsys.xs2a.adapter.service.config.AdapterConfig;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class OauthHeaderInterceptor
implements Request.Builder.Interceptor {
    private static final String BANK_CODE_FOR_OAUTH = "adorsys.oauth_approach.bank_code";
    private static final String OAUTH_HEADER_VALUE = "adorsys.oauth_approach.header_value";
    static final String OAUTH_HEADER_NAME = "adorsys.oauth_approach.header_name";

    public Request.Builder apply(Request.Builder builder) {
        String oauthBankCode = AdapterConfig.readProperty((String)BANK_CODE_FOR_OAUTH, (String)"");
        List<String> bankCodes = Arrays.stream(oauthBankCode.split(",")).map(String::trim).collect(Collectors.toList());
        String requestBankCode = (String)builder.headers().get("X-GTW-Bank-Code");
        if (oauthBankCode.isEmpty() || !bankCodes.contains(requestBankCode)) {
            return builder;
        }
        String oauthHeaderName = AdapterConfig.readProperty((String)OAUTH_HEADER_NAME, (String)"");
        String headerValue = this.getOauthHeaderValue(bankCodes, requestBankCode);
        if (!oauthHeaderName.isEmpty() && !headerValue.isEmpty()) {
            builder.header(oauthHeaderName, headerValue);
        }
        return builder;
    }

    private String getOauthHeaderValue(List<String> oauthBankCodes, String requestBankCode) {
        int idx = oauthBankCodes.indexOf(requestBankCode);
        String headerValue = AdapterConfig.readProperty((String)OAUTH_HEADER_VALUE, (String)"true");
        List headerValues = Arrays.stream(headerValue.split(",")).map(String::trim).collect(Collectors.toList());
        return headerValues.size() > idx ? (String)headerValues.get(idx) : "";
    }
}

