/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.adorsys.service.impl.mapper;

import de.adorsys.xs2a.adapter.adorsys.service.impl.mapper.ConsentCreationResponseMapper;
import de.adorsys.xs2a.adapter.adorsys.service.impl.model.AdorsysIntegChallengeData;
import de.adorsys.xs2a.adapter.adorsys.service.impl.model.AdorsysIntegConsentCreationResponse;
import de.adorsys.xs2a.adapter.service.model.AuthenticationObject;
import de.adorsys.xs2a.adapter.service.model.ChallengeData;
import de.adorsys.xs2a.adapter.service.model.ConsentCreationResponse;
import de.adorsys.xs2a.adapter.service.model.Link;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConsentCreationResponseMapperImpl
implements ConsentCreationResponseMapper {
    @Override
    public ConsentCreationResponse toConsentCreationResponse(AdorsysIntegConsentCreationResponse response) {
        if (response == null) {
            return null;
        }
        ConsentCreationResponse consentCreationResponse = new ConsentCreationResponse();
        consentCreationResponse.setConsentStatus(response.getConsentStatus());
        consentCreationResponse.setConsentId(response.getConsentId());
        List<AuthenticationObject> list = response.getScaMethods();
        if (list != null) {
            consentCreationResponse.setScaMethods(new ArrayList<AuthenticationObject>(list));
        }
        consentCreationResponse.setChosenScaMethod(response.getChosenScaMethod());
        consentCreationResponse.setChallengeData(this.adorsysIntegChallengeDataToChallengeData(response.getChallengeData()));
        Map<String, Link> map = response.getLinks();
        if (map != null) {
            consentCreationResponse.setLinks(new HashMap<String, Link>(map));
        }
        consentCreationResponse.setMessage(response.getMessage());
        return consentCreationResponse;
    }

    protected ChallengeData adorsysIntegChallengeDataToChallengeData(AdorsysIntegChallengeData adorsysIntegChallengeData) {
        if (adorsysIntegChallengeData == null) {
            return null;
        }
        ChallengeData challengeData = new ChallengeData();
        byte[] image = adorsysIntegChallengeData.getImage();
        if (image != null) {
            challengeData.setImage(Arrays.copyOf(image, image.length));
        }
        challengeData.setData(this.toListOfString(adorsysIntegChallengeData.getData()));
        challengeData.setImageLink(adorsysIntegChallengeData.getImageLink());
        challengeData.setOtpMaxLength(adorsysIntegChallengeData.getOtpMaxLength());
        challengeData.setOtpFormat(adorsysIntegChallengeData.getOtpFormat());
        challengeData.setAdditionalInformation(adorsysIntegChallengeData.getAdditionalInformation());
        return challengeData;
    }
}

