/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.adorsys.service.provider;

import de.adorsys.xs2a.adapter.adapter.BasePaymentInitiationService;
import de.adorsys.xs2a.adapter.adapter.oauth2.api.BaseOauth2Api;
import de.adorsys.xs2a.adapter.adapter.oauth2.api.model.AuthorisationServerMetaData;
import de.adorsys.xs2a.adapter.adorsys.service.AdorsysAccountInformationService;
import de.adorsys.xs2a.adapter.adorsys.service.AdorsysIntegOauth2Service;
import de.adorsys.xs2a.adapter.adorsys.service.provider.OauthHeaderInterceptor;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.http.Request;
import de.adorsys.xs2a.adapter.http.RequestSigningInterceptor;
import de.adorsys.xs2a.adapter.service.AccountInformationService;
import de.adorsys.xs2a.adapter.service.Oauth2Service;
import de.adorsys.xs2a.adapter.service.Oauth2ServiceFactory;
import de.adorsys.xs2a.adapter.service.PaymentInitiationService;
import de.adorsys.xs2a.adapter.service.Pkcs12KeyStore;
import de.adorsys.xs2a.adapter.service.config.AdapterConfig;
import de.adorsys.xs2a.adapter.service.link.LinksRewriter;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import de.adorsys.xs2a.adapter.service.oauth.Oauth2Api;
import de.adorsys.xs2a.adapter.service.provider.AccountInformationServiceProvider;
import de.adorsys.xs2a.adapter.service.provider.PaymentInitiationServiceProvider;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class AdorsysIntegServiceProvider
implements AccountInformationServiceProvider,
PaymentInitiationServiceProvider,
Oauth2ServiceFactory {
    private final OauthHeaderInterceptor oauthHeaderInterceptor = new OauthHeaderInterceptor();
    private final boolean requestSigningEnabled = Boolean.parseBoolean(AdapterConfig.readProperty((String)"adorsys.request_signing.enabled", (String)"false"));

    public PaymentInitiationService getPaymentInitiationService(Aspsp aspsp, HttpClientFactory httpClientFactory, Pkcs12KeyStore keyStore, LinksRewriter linksRewriter) {
        return new BasePaymentInitiationService(aspsp, httpClientFactory.getHttpClient(this.getAdapterId()), this.getInterceptor(keyStore), linksRewriter);
    }

    private Request.Builder.Interceptor getInterceptor(Pkcs12KeyStore keyStore) {
        if (this.requestSigningEnabled) {
            RequestSigningInterceptor requestSigningInterceptor = new RequestSigningInterceptor(keyStore);
            return requestBuilder -> {
                this.oauthHeaderInterceptor.apply((Request.Builder)requestBuilder);
                requestBuilder.header("Date", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()));
                requestSigningInterceptor.apply(requestBuilder);
                String certificate = (String)requestBuilder.headers().get("TPP-Signature-Certificate");
                requestBuilder.header("TPP-Signature-Certificate", "-----BEGIN CERTIFICATE-----" + certificate + "-----END CERTIFICATE-----");
                return requestBuilder;
            };
        }
        return this.oauthHeaderInterceptor;
    }

    public AccountInformationService getAccountInformationService(Aspsp aspsp, HttpClientFactory httpClientFactory, Pkcs12KeyStore keyStore, LinksRewriter linksRewriter) {
        return new AdorsysAccountInformationService(aspsp, httpClientFactory.getHttpClient(this.getAdapterId()), this.getInterceptor(keyStore), linksRewriter);
    }

    public Oauth2Service getOauth2Service(Aspsp aspsp, HttpClientFactory httpClientFactory, Pkcs12KeyStore keyStore) {
        HttpClient httpClient = httpClientFactory.getHttpClient(this.getAdapterId());
        return new AdorsysIntegOauth2Service(aspsp, httpClient, (Oauth2Api)new BaseOauth2Api(httpClient, AuthorisationServerMetaData.class));
    }

    public String getAdapterId() {
        return "adorsys-integ-adapter";
    }
}

