/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.adorsys.service;

import de.adorsys.xs2a.adapter.adapter.BaseAccountInformationService;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.Request;
import de.adorsys.xs2a.adapter.http.ResponseHandlers;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.RequestParams;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.link.LinksRewriter;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import de.adorsys.xs2a.adapter.service.model.ConsentCreationResponse;
import de.adorsys.xs2a.adapter.service.model.Consents;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class AdorsysAccountInformationService
extends BaseAccountInformationService {
    private static final String ACCEPT_ALL = "*/*";
    private static final String ACCEPT_JSON = "application/json";

    public AdorsysAccountInformationService(Aspsp aspsp, HttpClient httpClient, Request.Builder.Interceptor requestBuilderInterceptor, LinksRewriter linksRewriter) {
        super(aspsp, httpClient, requestBuilderInterceptor, linksRewriter);
    }

    public Response<ConsentCreationResponse> createConsent(RequestHeaders requestHeaders, RequestParams requestParams, Consents body) {
        return this.createConsent(requestHeaders, requestParams, body, Function.identity(), ResponseHandlers.consentCreationResponseHandler((String)this.getIdpUri(), ConsentCreationResponse.class));
    }

    protected Map<String, String> populatePostHeaders(Map<String, String> headers) {
        return super.populatePostHeaders(this.modifyAcceptHeader(headers));
    }

    protected Map<String, String> populatePutHeaders(Map<String, String> headers) {
        return super.populatePutHeaders(this.modifyAcceptHeader(headers));
    }

    protected Map<String, String> populateGetHeaders(Map<String, String> headers) {
        return super.populateGetHeaders(this.modifyAcceptHeader(headers));
    }

    protected Map<String, String> populateDeleteHeaders(Map<String, String> headers) {
        return super.populateDeleteHeaders(this.modifyAcceptHeader(headers));
    }

    private Map<String, String> modifyAcceptHeader(Map<String, String> headers) {
        String acceptValue = headers.get("Accept");
        if (StringUtils.isBlank((CharSequence)acceptValue) || acceptValue.equals(ACCEPT_ALL)) {
            headers.put("Accept", ACCEPT_JSON);
        }
        return headers;
    }
}

