/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.worksheetloader;

import com.google.common.collect.Lists;
import de.adorsys.sts.resourceserver.service.ResourceServerProcessorService;
import de.adorsys.sts.worksheetloader.ReadUserCredentials;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginLoader {
    Logger LOG = LoggerFactory.getLogger(LoginLoader.class);
    @Autowired
    private ResourceServerProcessorService resourceServerProcessorService;

    public void update(Row row) {
        Optional<ReadUserCredentials> userCredentialsFromRow = this.parseFromRow(row);
        if (userCredentialsFromRow.isPresent()) {
            ReadUserCredentials readUserCredentials = userCredentialsFromRow.get();
            List<ReadUserCredentials.ServerAndUserEncKey> serverAndUserEncKeyList = readUserCredentials.getServerAndUserEncKeyList();
            for (ReadUserCredentials.ServerAndUserEncKey serverAndUserEncKey : serverAndUserEncKeyList) {
                this.resourceServerProcessorService.storeCredentials(readUserCredentials.getLogin(), readUserCredentials.getPassword(), serverAndUserEncKey.getServerAudienceName(), serverAndUserEncKey.getUserEncKey());
            }
        }
    }

    private Optional<ReadUserCredentials> parseFromRow(Row row) {
        Optional<ReadUserCredentials> userCredentials = Optional.empty();
        Optional<String> login = this.readText(row, 0);
        if (!login.isPresent()) {
            return userCredentials;
        }
        Optional<String> password = this.readText(row, 1);
        if (!password.isPresent()) {
            return userCredentials;
        }
        List<ReadUserCredentials.ServerAndUserEncKey> serverAndEncKeyList = this.readFrom(row);
        if (serverAndEncKeyList.isEmpty()) {
            return userCredentials;
        }
        return Optional.of(ReadUserCredentials.builder().login(login.get()).password(password.get()).serverAndUserEncKeyList(serverAndEncKeyList).build());
    }

    private List<ReadUserCredentials.ServerAndUserEncKey> readFrom(Row row) {
        String[] serverAndEncKeyArray;
        ArrayList serverAndUserEncKeyList = Lists.newArrayList();
        Optional<String> serverAndEncKeyList = this.readText(row, 2);
        if (!serverAndEncKeyList.isPresent()) {
            return serverAndUserEncKeyList;
        }
        for (String serverAndEncKey : serverAndEncKeyArray = StringUtils.split((String)serverAndEncKeyList.get(), (String)",")) {
            String[] perUser = StringUtils.split((String)serverAndEncKey, (String)"=");
            if (perUser.length < 2) continue;
            ReadUserCredentials.ServerAndUserEncKey serverAndUserEncKey = ReadUserCredentials.ServerAndUserEncKey.builder().serverAudienceName(perUser[0]).userEncKey(perUser[1]).build();
            serverAndUserEncKeyList.add(serverAndUserEncKey);
        }
        return serverAndUserEncKeyList;
    }

    private Optional<String> readText(Row row, int cellIndex) {
        Optional<String> text = Optional.empty();
        Cell cell = row.getCell(cellIndex);
        if (cell != null && StringUtils.isNotBlank((CharSequence)cell.getStringCellValue())) {
            String value = cell.getStringCellValue().trim();
            text = Optional.of(value);
        }
        return text;
    }
}

