/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.worksheetloader;

import com.google.common.collect.Lists;
import de.adorsys.sts.common.user.DefaultObjectMapper;
import de.adorsys.sts.common.user.UserDataService;
import de.adorsys.sts.resourceserver.ResourceServerProcessor;
import de.adorsys.sts.worksheetloader.ReadUserCredentials;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.adorsys.encobject.domain.KeyCredentials;
import org.adorsys.encobject.filesystem.FsPersistenceFactory;
import org.adorsys.encobject.service.KeystoreNotFoundException;
import org.adorsys.encobject.userdata.ObjectMapperSPI;
import org.adorsys.encobject.userdata.ObjectPersistenceAdapter;
import org.adorsys.encobject.userdata.UserDataNamingPolicy;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginLoader {
    Logger LOG = LoggerFactory.getLogger(LoginLoader.class);
    @Autowired
    private UserDataNamingPolicy namingPolicy;
    @Autowired
    private FsPersistenceFactory persFactory;
    @Autowired
    private ResourceServerProcessor resourceServerProcessor;
    private static DefaultObjectMapper objectMapper = new DefaultObjectMapper();

    public void update(Row row) {
        Optional<ReadUserCredentials> userCredentialsFromRow = this.parseFromRow(row);
        if (userCredentialsFromRow.isPresent()) {
            ReadUserCredentials readUserCredentials = userCredentialsFromRow.get();
            KeyCredentials keyCredentials = this.namingPolicy.newKeyCredntials(readUserCredentials.getLogin(), readUserCredentials.getPassword());
            ObjectPersistenceAdapter objectPersistenceAdapter = new ObjectPersistenceAdapter(this.persFactory.getEncObjectService(), keyCredentials, (ObjectMapperSPI)objectMapper);
            UserDataService userDataService = new UserDataService(this.namingPolicy, objectPersistenceAdapter);
            if (!userDataService.hasAccount()) {
                try {
                    userDataService.addAccount();
                }
                catch (KeystoreNotFoundException e) {
                    throw new IllegalStateException();
                }
            }
            List<ReadUserCredentials.ServerAndUserEncKey> serverAndUserEncKeyList = readUserCredentials.getServerAndUserEncKeyList();
            for (ReadUserCredentials.ServerAndUserEncKey serverAndUserEncKey : serverAndUserEncKeyList) {
                this.resourceServerProcessor.storeUserCredentials(userDataService, serverAndUserEncKey.getUserEncKey(), serverAndUserEncKey.getServerAudienceName());
            }
        }
    }

    private Optional<ReadUserCredentials> parseFromRow(Row row) {
        Optional<ReadUserCredentials> userCredentials = Optional.empty();
        Optional<String> login = this.readText(row, 0);
        if (!login.isPresent()) {
            return userCredentials;
        }
        Optional<String> password = this.readText(row, 1);
        if (!password.isPresent()) {
            return userCredentials;
        }
        List<ReadUserCredentials.ServerAndUserEncKey> serverAndEncKeyList = this.readFrom(row);
        if (serverAndEncKeyList.isEmpty()) {
            return userCredentials;
        }
        return Optional.of(ReadUserCredentials.builder().login(login.get()).password(password.get()).serverAndUserEncKeyList(serverAndEncKeyList).build());
    }

    private List<ReadUserCredentials.ServerAndUserEncKey> readFrom(Row row) {
        String[] serverAndEncKeyArray;
        ArrayList serverAndUserEncKeyList = Lists.newArrayList();
        Optional<String> serverAndEncKeyList = this.readText(row, 2);
        if (!serverAndEncKeyList.isPresent()) {
            return serverAndUserEncKeyList;
        }
        for (String serverAndEncKey : serverAndEncKeyArray = StringUtils.split((String)serverAndEncKeyList.get(), (String)",")) {
            String[] perUser = StringUtils.split((String)serverAndEncKey, (String)"=");
            if (perUser.length < 2) continue;
            ReadUserCredentials.ServerAndUserEncKey serverAndUserEncKey = ReadUserCredentials.ServerAndUserEncKey.builder().serverAudienceName(perUser[0]).userEncKey(perUser[1]).build();
            serverAndUserEncKeyList.add(serverAndUserEncKey);
        }
        return serverAndUserEncKeyList;
    }

    private Optional<String> readText(Row row, int cellIndex) {
        Optional<String> text = Optional.empty();
        Cell cell = row.getCell(cellIndex);
        if (cell != null && StringUtils.isNotBlank((CharSequence)cell.getStringCellValue())) {
            String value = cell.getStringCellValue().trim();
            text = Optional.of(value);
        }
        return text;
    }
}

