/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.tokenauth;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.SecretJWK;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.JWKSourceBuilder;
import com.nimbusds.jose.proc.SecurityContext;
import java.net.URL;
import java.security.Key;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthServer {
    private static final Logger log = LoggerFactory.getLogger(AuthServer.class);
    private String name;
    private final String issUrl;
    private final String jwksUrl;
    private final int refreshIntervalSeconds;
    JWKSource<SecurityContext> jwkSource;
    final ConcurrentHashMap<String, JWK> jwkCache = new ConcurrentHashMap();
    long lastCacheUpdate = 0L;

    public AuthServer(String name, String issUrl, String jwksUrl) {
        this(name, issUrl, jwksUrl, 600);
    }

    public AuthServer(String name, String issUrl, String jwksUrl, int refreshIntervalSeconds) {
        this.name = name;
        this.issUrl = issUrl;
        this.jwksUrl = jwksUrl;
        this.refreshIntervalSeconds = refreshIntervalSeconds;
        this.jwkSource = JWKSourceBuilder.create((URL)new URL(this.jwksUrl)).build();
    }

    private void updateJwkCache() throws JsonWebKeyRetrievalException {
        log.debug("Thread entering updateJwkCache: " + Thread.currentThread().getId());
        try {
            List jwks = this.jwkSource.get(new JWKSelector(new JWKMatcher.Builder().build()), null);
            this.onJsonWebKeySetRetrieved(jwks);
            this.jwkCache.clear();
            for (JWK jwk : jwks) {
                this.jwkCache.put(jwk.getKeyID(), jwk);
            }
            this.lastCacheUpdate = new Date().getTime();
        }
        catch (Exception e) {
            throw new JsonWebKeyRetrievalException(e);
        }
        log.debug("Thread leaving updateJwkCache: " + Thread.currentThread().getId());
    }

    public Key getJWK(String keyID) throws JsonWebKeyRetrievalException {
        JWK jwk;
        log.debug("Thread entering getJWK: {}", (Object)Thread.currentThread().getId());
        Date now = new Date();
        long currentTime = now.getTime();
        if (currentTime - this.lastCacheUpdate > (long)this.refreshIntervalSeconds * 1000L || this.jwkCache.isEmpty()) {
            log.debug("Cache is invalid or empty, updating the cache...");
            this.updateJwkCache();
            log.debug("Cache updated successfully");
        }
        if ((jwk = this.jwkCache.get(keyID)) == null) {
            log.error("Key with ID {} not found in cache", (Object)keyID);
            throw new JsonWebKeyRetrievalException("Key with ID " + keyID + " not found in cache");
        }
        log.debug("JWK for key ID {} found in cache", (Object)keyID);
        if (jwk instanceof RSAKey) {
            try {
                log.debug("JWK is instance of RSAKey");
                return ((RSAKey)jwk).toPublicKey();
            }
            catch (JOSEException e) {
                log.error("Error while converting RSAKey to public key", (Throwable)e);
                throw new JsonWebKeyRetrievalException(e);
            }
        }
        if (jwk instanceof SecretJWK) {
            log.debug("JWK is instance of SecretJWK");
            return ((SecretJWK)jwk).toSecretKey();
        }
        log.error("Unknown key type {}", jwk.getClass());
        throw new JsonWebKeyRetrievalException("unknown key type " + jwk.getClass());
    }

    protected void onJsonWebKeySetRetrieved(List<JWK> jwks) {
        log.info("Retrieved {} keys from {}", (Object)jwks.size(), (Object)this.jwksUrl);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getIssUrl() {
        return this.issUrl;
    }

    public void setJwkSource(JWKSource<SecurityContext> jwkSource) {
        this.jwkSource = jwkSource;
    }

    protected static class JsonWebKeyRetrievalException
    extends RuntimeException {
        public JsonWebKeyRetrievalException(Throwable cause) {
            super(cause);
        }

        public JsonWebKeyRetrievalException(String message) {
            super(message);
        }
    }
}

