/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.tokenauth;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.SecretJWK;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import java.net.URL;
import java.security.Key;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class AuthServer {
    private String name;
    private final String issUrl;
    private final String jwksUrl;
    private int refreshIntervalSeconds = 600;
    private final ConcurrentHashMap<String, JWK> jwkCache = new ConcurrentHashMap();
    private long lastCacheUpdate = 0L;

    public AuthServer(String name, String issUrl, String jwksUrl) {
        this.name = name;
        this.issUrl = issUrl;
        this.jwksUrl = jwksUrl;
    }

    public AuthServer(String name, String issUrl, String jwksUrl, int refreshIntervalSeconds) {
        this.name = name;
        this.issUrl = issUrl;
        this.jwksUrl = jwksUrl;
        this.refreshIntervalSeconds = refreshIntervalSeconds;
    }

    private void updateJwkCache() throws JsonWebKeyRetrievalException {
        try {
            RemoteJWKSet jwkSource = new RemoteJWKSet(new URL(this.jwksUrl));
            List jwks = jwkSource.get(new JWKSelector(new JWKMatcher.Builder().build()), null);
            this.onJsonWebKeySetRetrieved(jwks);
            this.jwkCache.clear();
            for (JWK jwk : jwks) {
                this.jwkCache.put(jwk.getKeyID(), jwk);
            }
            this.lastCacheUpdate = new Date().getTime();
        }
        catch (Exception e) {
            throw new JsonWebKeyRetrievalException(e);
        }
    }

    public Key getJWK(String keyID) throws JsonWebKeyRetrievalException {
        JWK jwk;
        Date now = new Date();
        long currentTime = now.getTime();
        if (currentTime - this.lastCacheUpdate > (long)this.refreshIntervalSeconds * 1000L || this.jwkCache.isEmpty()) {
            this.updateJwkCache();
        }
        if ((jwk = this.jwkCache.get(keyID)) == null) {
            throw new JsonWebKeyRetrievalException("Key with ID " + keyID + " not found in cache");
        }
        if (jwk instanceof RSAKey) {
            try {
                return ((RSAKey)jwk).toPublicKey();
            }
            catch (JOSEException e) {
                throw new JsonWebKeyRetrievalException(e);
            }
        }
        if (jwk instanceof SecretJWK) {
            return ((SecretJWK)jwk).toSecretKey();
        }
        throw new JsonWebKeyRetrievalException("unknown key type " + jwk.getClass());
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void onJsonWebKeySetRetrieved(List<JWK> jwks) {
    }

    public String getName() {
        return this.name;
    }

    public String getIssUrl() {
        return this.issUrl;
    }

    public static class JsonWebKeyRetrievalException
    extends RuntimeException {
        public JsonWebKeyRetrievalException(Throwable cause) {
            super(cause);
        }

        public JsonWebKeyRetrievalException(String message) {
            super(message);
        }
    }
}

