/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.tokenauth;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.KeySourceException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.SecretJWK;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.SecurityContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;

public class AuthServer {
    private String name;
    private String issUrl;
    private String jwksUrl;
    private int refreshIntervalSeconds = 600;
    private Date refreshExp = null;
    private JWKSource<SecurityContext> jwkSource = null;

    public AuthServer(String name, String issUrl, String jwksUrl) {
        this.name = name;
        this.issUrl = issUrl;
        this.jwksUrl = jwksUrl;
    }

    public AuthServer(String name, String issUrl, String jwksUrl, int refreshIntervalSeconds) {
        this.name = name;
        this.issUrl = issUrl;
        this.jwksUrl = jwksUrl;
        this.refreshIntervalSeconds = refreshIntervalSeconds;
    }

    public Key getJWK(String keyID) throws JsonWebKeyRetrievalException {
        List list;
        Date now = new Date();
        if (this.refreshExp == null || now.after(this.refreshExp)) {
            this.refreshExp = DateUtils.addSeconds((Date)now, (int)this.refreshIntervalSeconds);
            try {
                this.jwkSource = new RemoteJWKSet(new URL(this.jwksUrl));
            }
            catch (MalformedURLException e) {
                throw new JsonWebKeyRetrievalException((Throwable)e);
            }
        }
        JWKSelector jwkSelector = new JWKSelector(new JWKMatcher.Builder().keyID(keyID).build());
        try {
            list = this.jwkSource.get(jwkSelector, null);
            this.onJsonWebKeySetRetrieved(list);
        }
        catch (KeySourceException e) {
            throw new JsonWebKeyRetrievalException((Throwable)e);
        }
        if (list.isEmpty()) {
            throw new JsonWebKeyRetrievalException("Unable to retrieve keys: received JWKSet is empty");
        }
        JWK jwk = (JWK)list.iterator().next();
        if (jwk instanceof RSAKey) {
            try {
                return ((RSAKey)jwk).toPublicKey();
            }
            catch (JOSEException e) {
                throw new JsonWebKeyRetrievalException((Throwable)e);
            }
        }
        if (jwk instanceof SecretJWK) {
            return ((SecretJWK)jwk).toSecretKey();
        }
        throw new JsonWebKeyRetrievalException("unknown key type " + String.valueOf(jwk.getClass()));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIssUrl() {
        return this.issUrl;
    }

    public void setIssUrl(String issUrl) {
        this.issUrl = issUrl;
    }

    public String getJwksUrl() {
        return this.jwksUrl;
    }

    public void setJwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
    }

    public int getRefreshIntervalSeconds() {
        return this.refreshIntervalSeconds;
    }

    public void setRefreshIntervalSeconds(int refreshIntervalSeconds) {
        this.refreshIntervalSeconds = refreshIntervalSeconds;
    }

    protected void onJsonWebKeySetRetrieved(List<JWK> jwks) {
    }

    public class JsonWebKeyRetrievalException
    extends RuntimeException {
        public JsonWebKeyRetrievalException(Throwable cause) {
            super(cause);
        }

        public JsonWebKeyRetrievalException(String message) {
            super(message);
        }
    }
}

