/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.tokenauth;

import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.nimbusds.jwt.util.DateUtils;
import java.time.Clock;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTClaimsSetVerifierWithLogs<C extends SecurityContext>
implements JWTClaimsSetVerifier<C> {
    private final Logger logger = LoggerFactory.getLogger(JWTClaimsSetVerifierWithLogs.class);
    private static final int DEFAULT_MAX_CLOCK_SKEW_SECONDS = 60;
    private final Clock clock;

    public void verify(JWTClaimsSet claimsSet, SecurityContext context) throws BadJWTException {
        Date now = Date.from(this.clock.instant());
        Date exp = claimsSet.getExpirationTime();
        if (exp != null && !DateUtils.isAfter((Date)exp, (Date)now, (long)60L)) {
            String msg = "Expired JWT";
            this.logger.error(msg);
            throw new BadJWTException(msg);
        }
        Date nbf = claimsSet.getNotBeforeTime();
        if (nbf != null && !DateUtils.isBefore((Date)nbf, (Date)now, (long)60L)) {
            String msg = "JWT before use time";
            this.logger.error(msg);
            throw new BadJWTException(msg);
        }
    }

    public JWTClaimsSetVerifierWithLogs(Clock clock) {
        this.clock = clock;
    }
}

