/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.tokenauth;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import de.adorsys.sts.tokenauth.AuthServer;
import de.adorsys.sts.tokenauth.KeycloakTokenRolesParser;
import de.adorsys.sts.tokenauth.MultiAuthJWSKeySelector;
import de.adorsys.sts.tokenauth.StringListRolesParser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.adorsys.envutils.EnvProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    static final String TOKEN_PREFIX = "Bearer ";
    static final String HEADER_STRING = "Authorization";
    private Map<String, AuthServer> authServers = new HashMap<String, AuthServer>();
    private KeycloakTokenRolesParser keycloakTokenRolesParser = new KeycloakTokenRolesParser();
    private StringListRolesParser stringListRolesParser = new StringListRolesParser();

    @PostConstruct
    public void postConstruct() {
        String auth_servers_prop = EnvProperties.getEnvOrSysProp((String)"AUTH_SERVER_NAMES", (boolean)true);
        String[] auth_servers = StringUtils.split((String)auth_servers_prop);
        if (auth_servers != null) {
            for (String auth_server : auth_servers) {
                String auth_server_iss_url = EnvProperties.getEnvOrSysProp((String)(auth_server + "_AUTH_SERVER_ISS_URL"), (boolean)false);
                String auth_server_jwks_url = EnvProperties.getEnvOrSysProp((String)(auth_server + "_AUTH_SERVER_JWKS_URL"), (boolean)false);
                String auth_server_jwks_refresh_int = EnvProperties.getEnvOrSysProp((String)(auth_server + "_AUTH_SERVER_JWKS_URL"), (String)"600");
                AuthServer authServer = new AuthServer(auth_server, auth_server_iss_url, auth_server_jwks_url);
                if (StringUtils.isNumeric((CharSequence)auth_server_jwks_refresh_int)) {
                    int refreshIntervalSeconds = Integer.parseInt(auth_server_jwks_refresh_int);
                    authServer.setRefreshIntervalSeconds(refreshIntervalSeconds);
                }
                this.authServers.put(authServer.getIssUrl(), authServer);
            }
        }
    }

    public Authentication getAuthentication(HttpServletRequest request) {
        String token = request.getHeader(HEADER_STRING);
        if (token == null) {
            return null;
        }
        if (!StringUtils.startsWithIgnoreCase((CharSequence)token, (CharSequence)TOKEN_PREFIX)) {
            return null;
        }
        JWTClaimsSet jwtClaimsSet = this.checkBearerToken(token = StringUtils.substringAfterLast((String)token, (String)" "));
        if (jwtClaimsSet == null) {
            return null;
        }
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        List<String> roles = this.extractRoles(jwtClaimsSet);
        if (roles != null) {
            for (String role : roles) {
                authorities.add(new SimpleGrantedAuthority(role));
            }
        }
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)jwtClaimsSet.getSubject(), (Object)jwtClaimsSet, authorities);
        return authenticationToken;
    }

    public JWTClaimsSet checkBearerToken(String token) {
        JWTClaimsSet jwtClaimsSet = null;
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            JWSAlgorithm algorithm = signedJWT.getHeader().getAlgorithm();
            if (JWSAlgorithm.NONE.equals((Object)algorithm)) {
                return null;
            }
            String issuer = signedJWT.getJWTClaimsSet().getIssuer();
            AuthServer authServer = this.authServers.get(issuer);
            if (authServer == null) {
                return null;
            }
            MultiAuthJWSKeySelector jwsKeySelector = new MultiAuthJWSKeySelector(authServer);
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            jwtProcessor.setJWSKeySelector(jwsKeySelector);
            SecurityContext context = null;
            jwtClaimsSet = jwtProcessor.process(signedJWT, context);
        }
        catch (JOSEException | BadJOSEException | ParseException e) {
            return null;
        }
        return jwtClaimsSet;
    }

    public List<String> extractRoles(JWTClaimsSet claimSet) {
        ArrayList<String> results = new ArrayList<String>();
        this.stringListRolesParser.extractRoles(claimSet, "scp", results);
        this.stringListRolesParser.extractRoles(claimSet, "roles", results);
        this.keycloakTokenRolesParser.parseRoles(claimSet, results);
        return results;
    }
}

