/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.tokenauth;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.KeySourceException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.SecretJWK;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.SecurityContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;

public class AuthServer {
    private String name;
    private String issUrl;
    private String jwksUrl;
    private int refreshIntervalSeconds = 600;
    private Date refreshExp = null;
    private JWKSource<SecurityContext> jwkSource = null;

    public AuthServer(String name, String issUrl, String jwksUrl) {
        this.name = name;
        this.issUrl = issUrl;
        this.jwksUrl = jwksUrl;
    }

    public AuthServer(String name, String issUrl, String jwksUrl, int refreshIntervalSeconds) {
        this.name = name;
        this.issUrl = issUrl;
        this.jwksUrl = jwksUrl;
        this.refreshIntervalSeconds = refreshIntervalSeconds;
    }

    public Key getJWK(String keyID) {
        List list;
        Date now = new Date();
        if (this.refreshExp == null || now.after(this.refreshExp)) {
            this.refreshExp = DateUtils.addSeconds((Date)now, (int)this.refreshIntervalSeconds);
            try {
                this.jwkSource = new RemoteJWKSet(new URL(this.jwksUrl));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        JWKSelector jwkSelector = new JWKSelector(new JWKMatcher.Builder().keyID(keyID).build());
        SecurityContext context = null;
        try {
            list = this.jwkSource.get(jwkSelector, context);
        }
        catch (KeySourceException e) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        JWK jwk = (JWK)list.iterator().next();
        if (jwk instanceof RSAKey) {
            try {
                return ((RSAKey)jwk).toPublicKey();
            }
            catch (JOSEException e) {
                return null;
            }
        }
        if (jwk instanceof SecretJWK) {
            return ((SecretJWK)jwk).toSecretKey();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIssUrl() {
        return this.issUrl;
    }

    public void setIssUrl(String issUrl) {
        this.issUrl = issUrl;
    }

    public String getJwksUrl() {
        return this.jwksUrl;
    }

    public void setJwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
    }

    public int getRefreshIntervalSeconds() {
        return this.refreshIntervalSeconds;
    }

    public void setRefreshIntervalSeconds(int refreshIntervalSeconds) {
        this.refreshIntervalSeconds = refreshIntervalSeconds;
    }
}

