/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.tokenauth;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import de.adorsys.sts.tokenauth.AuthServer;
import de.adorsys.sts.tokenauth.AuthServersProvider;
import de.adorsys.sts.tokenauth.BearerToken;
import de.adorsys.sts.tokenauth.KeycloakTokenRolesParser;
import de.adorsys.sts.tokenauth.MultiAuthJWSKeySelector;
import de.adorsys.sts.tokenauth.StringListRolesParser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class BearerTokenValidator {
    private final AuthServersProvider authServersProvider;
    private final KeycloakTokenRolesParser keycloakTokenRolesParser = new KeycloakTokenRolesParser();
    private final StringListRolesParser stringListRolesParser = new StringListRolesParser();

    public BearerTokenValidator(AuthServersProvider authServersProvider) {
        this.authServersProvider = authServersProvider;
    }

    public BearerToken extract(String token) {
        Optional<JWTClaimsSet> jwtClaimsSet = this.extractClaims(token);
        if (jwtClaimsSet.isPresent()) {
            List<String> roles = this.extractRoles(jwtClaimsSet.get());
            return BearerToken.builder().token(token).claims(jwtClaimsSet.get()).isValid(true).roles(roles).build();
        }
        this.onInvalidToken(token);
        return BearerToken.builder().token(token).isValid(false).build();
    }

    protected void onInvalidToken(String headerValue) {
    }

    private List<String> extractRoles(JWTClaimsSet claims) {
        ArrayList<String> results = new ArrayList<String>();
        this.stringListRolesParser.extractRoles(claims, "scp", results);
        this.stringListRolesParser.extractRoles(claims, "roles", results);
        this.keycloakTokenRolesParser.parseRoles(claims, results);
        return results;
    }

    protected void onTokenIsNull() {
    }

    protected void onAlgorithmIsNone(String token) {
    }

    protected void onAuthServerIsNull(String token, String issuer) {
    }

    protected void onErrorWhileExtractClaims(String token, Throwable e) {
    }

    private Optional<JWTClaimsSet> extractClaims(String token) {
        Optional<JWTClaimsSet> jwtClaimsSet = Optional.empty();
        if (token == null) {
            this.onTokenIsNull();
            return jwtClaimsSet;
        }
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            JWSAlgorithm algorithm = signedJWT.getHeader().getAlgorithm();
            if (JWSAlgorithm.NONE.equals((Object)algorithm)) {
                this.onAlgorithmIsNone(token);
                return jwtClaimsSet;
            }
            String issuer = signedJWT.getJWTClaimsSet().getIssuer();
            AuthServer authServer = this.authServersProvider.get(issuer);
            if (authServer == null) {
                this.onAuthServerIsNull(token, issuer);
                return jwtClaimsSet;
            }
            MultiAuthJWSKeySelector jwsKeySelector = new MultiAuthJWSKeySelector(authServer);
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            jwtProcessor.setJWSKeySelector(jwsKeySelector);
            SecurityContext context = null;
            JWTClaimsSet jwtClaims = jwtProcessor.process(signedJWT, context);
            jwtClaimsSet = Optional.of(jwtClaims);
        }
        catch (JOSEException | BadJOSEException | ParseException e) {
            this.onErrorWhileExtractClaims(token, e);
            return jwtClaimsSet;
        }
        return jwtClaimsSet;
    }
}

