/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.tokenauth;

import de.adorsys.sts.tokenauth.AuthServer;
import de.adorsys.sts.tokenauth.AuthServersProvider;
import java.util.HashMap;
import java.util.Map;
import org.adorsys.envutils.EnvProperties;
import org.apache.commons.lang3.StringUtils;

public class EnvironmentVariablesAuthServersProvider
implements AuthServersProvider {
    private Map<String, AuthServer> authServers;

    @Override
    public Map<String, AuthServer> getAll() {
        if (this.authServers == null) {
            this.authServers = this.read();
        }
        return this.authServers;
    }

    @Override
    public AuthServer get(String issuer) {
        return this.authServers.get(issuer);
    }

    private Map<String, AuthServer> read() {
        HashMap<String, AuthServer> authServers = new HashMap<String, AuthServer>();
        String auth_servers_prop = EnvProperties.getEnvOrSysProp((String)"AUTH_SERVER_NAMES", (boolean)true);
        String[] auth_servers = StringUtils.split((String)auth_servers_prop);
        if (auth_servers != null) {
            for (String auth_server : auth_servers) {
                String auth_server_iss_url = EnvProperties.getEnvOrSysProp((String)(auth_server + "_AUTH_SERVER_ISS_URL"), (boolean)false);
                String auth_server_jwks_url = EnvProperties.getEnvOrSysProp((String)(auth_server + "_AUTH_SERVER_JWKS_URL"), (boolean)false);
                String auth_server_jwks_refresh_int = EnvProperties.getEnvOrSysProp((String)(auth_server + "_AUTH_SERVER_REFRESH_INTERVAL"), (String)"600");
                AuthServer authServer = new AuthServer(auth_server, auth_server_iss_url, auth_server_jwks_url);
                if (StringUtils.isNumeric((CharSequence)auth_server_jwks_refresh_int)) {
                    int refreshIntervalSeconds = Integer.parseInt(auth_server_jwks_refresh_int);
                    authServer.setRefreshIntervalSeconds(refreshIntervalSeconds);
                }
                authServers.put(authServer.getIssUrl(), authServer);
            }
        }
        return authServers;
    }
}

