/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.tokenauth;

import com.nimbusds.jwt.JWTClaimsSet;
import java.beans.ConstructorProperties;
import java.util.List;

public class BearerToken {
    private final String token;
    private final JWTClaimsSet claims;
    private final List<String> roles;
    private final boolean isValid;

    @ConstructorProperties(value={"token", "claims", "roles", "isValid"})
    BearerToken(String token, JWTClaimsSet claims, List<String> roles, boolean isValid) {
        this.token = token;
        this.claims = claims;
        this.roles = roles;
        this.isValid = isValid;
    }

    public static BearerTokenBuilder builder() {
        return new BearerTokenBuilder();
    }

    public String getToken() {
        return this.token;
    }

    public JWTClaimsSet getClaims() {
        return this.claims;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public static class BearerTokenBuilder {
        private String token;
        private JWTClaimsSet claims;
        private List<String> roles;
        private boolean isValid;

        BearerTokenBuilder() {
        }

        public BearerTokenBuilder token(String token) {
            this.token = token;
            return this;
        }

        public BearerTokenBuilder claims(JWTClaimsSet claims) {
            this.claims = claims;
            return this;
        }

        public BearerTokenBuilder roles(List<String> roles) {
            this.roles = roles;
            return this;
        }

        public BearerTokenBuilder isValid(boolean isValid) {
            this.isValid = isValid;
            return this;
        }

        public BearerToken build() {
            return new BearerToken(this.token, this.claims, this.roles, this.isValid);
        }

        public String toString() {
            return "BearerToken.BearerTokenBuilder(token=" + this.token + ", claims=" + this.claims + ", roles=" + this.roles + ", isValid=" + this.isValid + ")";
        }
    }
}

