/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.tokenauth;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import de.adorsys.sts.tokenauth.AuthServer;
import de.adorsys.sts.tokenauth.EnvironmentVariablesAuthServersProvider;
import de.adorsys.sts.tokenauth.KeycloakTokenRolesParser;
import de.adorsys.sts.tokenauth.MultiAuthJWSKeySelector;
import de.adorsys.sts.tokenauth.StringListRolesParser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class BearerToken {
    static final String TOKEN_PREFIX = "Bearer ";
    static final String HEADER_STRING = "Authorization";
    private final EnvironmentVariablesAuthServersProvider authServersProvider = new EnvironmentVariablesAuthServersProvider();
    private final KeycloakTokenRolesParser keycloakTokenRolesParser = new KeycloakTokenRolesParser();
    private final StringListRolesParser stringListRolesParser = new StringListRolesParser();
    private final String token;
    private JWTClaimsSet claims;

    public BearerToken(String token) {
        this.token = token;
    }

    public boolean isValid() {
        return this.tryToGetClaims().isPresent();
    }

    public final JWTClaimsSet getClaims() {
        Optional<JWTClaimsSet> claims = this.tryToGetClaims();
        return claims.orElseThrow(() -> new IllegalStateException("claims cannot be parsed"));
    }

    private Optional<JWTClaimsSet> tryToGetClaims() {
        if (this.claims == null) {
            Optional<JWTClaimsSet> extractedClaims = this.extractClaims();
            extractedClaims.ifPresent(jwtClaimsSet -> {
                this.claims = jwtClaimsSet;
            });
        }
        return Optional.ofNullable(this.claims);
    }

    public List<String> extractRoles() {
        ArrayList<String> results = new ArrayList<String>();
        JWTClaimsSet claims = this.getClaims();
        this.stringListRolesParser.extractRoles(claims, "scp", results);
        this.stringListRolesParser.extractRoles(claims, "roles", results);
        this.keycloakTokenRolesParser.parseRoles(claims, results);
        return results;
    }

    private Optional<JWTClaimsSet> extractClaims() {
        Optional<JWTClaimsSet> jwtClaimsSet = Optional.empty();
        if (this.token == null) {
            return jwtClaimsSet;
        }
        if (!StringUtils.startsWithIgnoreCase((CharSequence)this.token, (CharSequence)TOKEN_PREFIX)) {
            return jwtClaimsSet;
        }
        String strippedToken = StringUtils.substringAfterLast((String)this.token, (String)" ");
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)strippedToken);
            JWSAlgorithm algorithm = signedJWT.getHeader().getAlgorithm();
            if (JWSAlgorithm.NONE.equals((Object)algorithm)) {
                return jwtClaimsSet;
            }
            String issuer = signedJWT.getJWTClaimsSet().getIssuer();
            AuthServer authServer = this.authServersProvider.get(issuer);
            if (authServer == null) {
                return jwtClaimsSet;
            }
            MultiAuthJWSKeySelector jwsKeySelector = new MultiAuthJWSKeySelector(authServer);
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            jwtProcessor.setJWSKeySelector(jwsKeySelector);
            SecurityContext context = null;
            JWTClaimsSet jwtClaims = jwtProcessor.process(signedJWT, context);
            jwtClaimsSet = Optional.of(jwtClaims);
        }
        catch (JOSEException | BadJOSEException | ParseException e) {
            return jwtClaimsSet;
        }
        return jwtClaimsSet;
    }
}

