/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.starter;

import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Provider;
import java.security.Security;
import org.adorsys.envutils.EnvProperties;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
public class SecureTokenServiceApplication {
    public static void main(String[] args) throws UnknownHostException {
        SecureTokenServiceApplication.turnOffEncPolicy();
        Security.addProvider((Provider)new BouncyCastleProvider());
        String keystorePassword = EnvProperties.getEnvOrSysProp((String)"KEYSTORE_PASSWORD", (boolean)true);
        if (StringUtils.isBlank((CharSequence)keystorePassword)) {
            keystorePassword = RandomStringUtils.randomAlphanumeric((int)16);
            System.setProperty("KEYSTORE_PASSWORD", keystorePassword);
            System.setProperty("RESET_KEYSTORE", "true");
            LoggerFactory.getLogger(SecureTokenServiceApplication.class).info("Newly generated Keystore Password: " + keystorePassword);
        }
        ConfigurableApplicationContext app = SpringApplication.run(SecureTokenServiceApplication.class, (String[])args);
        ConfigurableEnvironment env = app.getEnvironment();
        String protocol = "http";
        if (env.getProperty("server.ssl.key-store") != null) {
            protocol = "https";
        }
        LoggerFactory.getLogger(SecureTokenServiceApplication.class).info("\n----------------------------------------------------------\n\tApplication '{}' is running! Access URLs:\n\tLocal: \t\t{}://localhost:{}\n\tExternal: \t{}://{}:{}\n\tProfile(s): \t{}\n----------------------------------------------------------", new Object[]{env.getProperty("spring.application.name", "Secure Token Service"), protocol, env.getProperty("server.port", "8080"), protocol, InetAddress.getLocalHost().getHostAddress(), env.getProperty("server.port", "8080"), env.getActiveProfiles()});
    }

    public static void turnOffEncPolicy() {
        try {
            Field field = Class.forName("javax.crypto.JceSecurity").getDeclaredField("isRestricted");
            field.setAccessible(true);
            field.set(null, Boolean.FALSE);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            ex.printStackTrace(System.err);
        }
    }
}

