/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.starter.config;

import de.adorsys.sts.filter.JWTAuthenticationFilter;
import de.adorsys.sts.token.authentication.TokenAuthenticationService;
import de.adorsys.sts.tokenauth.BearerTokenValidator;
import java.security.Principal;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private TokenAuthenticationService tokenAuthenticationService;

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(HttpMethod.GET, new String[]{"/", "/pop", "/api-docs/**", "/v2/api-docs/**", "/swagger-resources/**", "/health", "/health.json", "/info", "/info.json"})).permitAll().antMatchers(new String[]{"/token/**"})).permitAll().antMatchers(this.actuatorEndpoints())).hasRole("ADMIN").antMatchers(new String[]{"/accounts"})).hasRole("USER").antMatchers(new String[]{"/bankAccess"})).hasRole("ADMIN").antMatchers(this.actuatorEndpoints())).denyAll().anyRequest()).authenticated();
        http.addFilterBefore((Filter)new JWTAuthenticationFilter(this.tokenAuthenticationService), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)new BasicAuthenticationFilter(this.authenticationManager()), BasicAuthenticationFilter.class);
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.inMemoryAuthentication().withUser("admin").password("password").roles(new String[]{"ADMIN"});
    }

    private String[] actuatorEndpoints() {
        return new String[]{"/auditevents", "/auditevents.json", "/dump", "/dump.json", "/metrics/**", "/metrics", "/metrics.json", "/beans", "/beans.json", "/loggers/**", "/loggers", "/loggers.json", "/trace", "/trace.json", "/configprops", "/configprops.json", "/heapdump", "/heapdump.json", "/autoconfig", "/autoconfig.json", "/mappings", "/mappings.json", "/env/**", "/env", "/env.json"};
    }

    @Bean
    @Scope(scopeName="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public Principal getPrincipal() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    @Bean
    TokenAuthenticationService tokenService(BearerTokenValidator bearerTokenValidator) {
        return new TokenAuthenticationService(bearerTokenValidator);
    }
}

