/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.token.tokenexchange.server;

import com.nimbusds.jose.proc.BadJOSEException;
import de.adorsys.sts.ResponseUtils;
import de.adorsys.sts.token.InvalidParameterException;
import de.adorsys.sts.token.MissingParameterException;
import de.adorsys.sts.token.api.TokenRequestForm;
import de.adorsys.sts.token.api.TokenResponse;
import de.adorsys.sts.token.tokenexchange.TokenExchangeRequest;
import de.adorsys.sts.token.tokenexchange.TokenExchangeService;
import de.adorsys.sts.token.tokenexchange.TokenValidationException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public class TokenExchangeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenExchangeController.class);
    private final TokenExchangeService tokenExchangeService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(consumes={"application/x-www-form-urlencoded"}, produces={"application/json"})
    @Operation(summary="Exchange Token", description="Create an access or refresh token given a valide subject token.", responses={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=TokenResponse.class))}), @ApiResponse(responseCode="400", description="Bad request", headers={@Header(name="error", description="invalid request")})})
    public ResponseEntity<Object> tokenExchange(@RequestBody @ModelAttribute TokenRequestForm tokenRequestForm, HttpServletRequest servletRequest) {
        if (log.isTraceEnabled()) {
            log.trace("POST tokenExchange started...");
        }
        TokenExchangeRequest tokenExchange = TokenExchangeController.getTokenExchangeRequest(tokenRequestForm, servletRequest);
        String errorMessage = "";
        try {
            TokenResponse tokenResponse = this.tokenExchangeService.exchangeToken(tokenExchange);
            ResponseEntity responseEntity = ResponseEntity.ok((Object)tokenResponse);
            return responseEntity;
        }
        catch (InvalidParameterException e) {
            errorMessage = e.getMessage();
            ResponseEntity<Object> responseEntity = ResponseUtils.invalidParam(e.getMessage());
            return responseEntity;
        }
        catch (MissingParameterException e) {
            errorMessage = e.getMessage();
            ResponseEntity<Object> responseEntity = ResponseUtils.missingParam(e.getMessage());
            return responseEntity;
        }
        catch (TokenValidationException e) {
            errorMessage = e.getMessage();
            ResponseEntity<Object> errorData = ResponseUtils.invalidParam(e.getMessage());
            ResponseEntity responseEntity = ResponseEntity.badRequest().body(errorData);
            return responseEntity;
        }
        catch (BadJOSEException e) {
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).header("source", new String[]{"sts"})).header("X-B3-TraceId", new String[]{servletRequest.getHeader("X-B3-TraceId")})).header("X-B3-SpanId", new String[]{servletRequest.getHeader("X-B3-SpanId")})).body((Object)e.getMessage());
            return responseEntity;
        }
        finally {
            if (log.isTraceEnabled()) {
                log.trace("POST tokenExchange finished: {}", (Object)errorMessage);
            }
        }
    }

    private static TokenExchangeRequest getTokenExchangeRequest(TokenRequestForm tokenRequestForm, HttpServletRequest servletRequest) {
        return TokenExchangeRequest.builder().grantType(tokenRequestForm.getGrantType()).resources(tokenRequestForm.getResources()).subjectToken(tokenRequestForm.getSubjectToken()).subjectTokenType(tokenRequestForm.getSubjectTokenType()).actorToken(tokenRequestForm.getActorToken()).actorTokenType(tokenRequestForm.getActorTokenType()).issuer(ResponseUtils.getIssuer(servletRequest)).scope(tokenRequestForm.getScope()).requestedTokenType(tokenRequestForm.getRequestedTokenType()).audiences(tokenRequestForm.getAudiences()).build();
    }

    @Generated
    protected TokenExchangeController(TokenExchangeService tokenExchangeService) {
        this.tokenExchangeService = tokenExchangeService;
    }
}

