/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.token.tokenexchange.client;

import de.adorsys.sts.common.util.ImmutableLists;
import de.adorsys.sts.token.api.TokenResponse;
import de.adorsys.sts.token.tokenexchange.TokenExchangeClient;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestTokenExchangeClient
implements TokenExchangeClient {
    private final RestTemplate restTemplate;

    public TokenResponse exchangeToken(String uri, List<String> audiences, String accessToken, Map<String, String> customHeaders) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Bearer " + accessToken);
        headers.add("Content-Type", "application/x-www-form-urlencoded");
        headers.add("Accept", "*/*");
        headers.add("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36");
        customHeaders.forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.addAll((Object)"audience", audiences);
        body.add((Object)"grant_type", (Object)"urn:ietf:params:oauth:grant-type:token-exchange");
        body.add((Object)"subject_token", (Object)accessToken);
        body.add((Object)"subject_token_type", (Object)"urn:ietf:params:oauth:token-type:jwt");
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)headers), TokenResponse.class, new Object[0]);
        return (TokenResponse)response.getBody();
    }

    public TokenResponse exchangeToken(String uri, String audiences, String accessToken, Map<String, String> customHeaders) {
        return this.exchangeToken(uri, ImmutableLists.of((Object)audiences, (Object[])new String[0]), accessToken, customHeaders);
    }

    public TokenResponse exchangeToken(String uri, List<String> audiences, String accessToken) {
        return this.exchangeToken(uri, audiences, accessToken, Collections.emptyMap());
    }

    public TokenResponse exchangeToken(String uri, String audience, String accessToken) {
        return this.exchangeToken(uri, ImmutableLists.of((Object)audience, (Object[])new String[0]), accessToken);
    }

    @Generated
    public RestTokenExchangeClient(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

