/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.token.authentication;

import de.adorsys.sts.token.authentication.AuthServerConfigurationProperties;
import de.adorsys.sts.token.authentication.LoggingAuthServer;
import de.adorsys.sts.tokenauth.AuthServer;
import de.adorsys.sts.tokenauth.AuthServersProvider;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationPropertiesAuthServerProvider
implements AuthServersProvider {
    private final AuthServerConfigurationProperties authServerConfigurationProperties;
    private Map<String, AuthServer> authServers;

    public Map<String, AuthServer> getAll() {
        return this.getOrReadAuthServers();
    }

    public AuthServer get(String issuer) {
        return this.getOrReadAuthServers().get(issuer);
    }

    private Map<String, AuthServer> getOrReadAuthServers() {
        if (this.authServers == null) {
            List<AuthServerConfigurationProperties.AuthServerProperties> authServersProperties = this.authServerConfigurationProperties.getAuthservers();
            this.authServers = authServersProperties.stream().map(this::mapFromProperties).collect(Collectors.toMap(AuthServer::getIssUrl, Function.identity()));
        }
        return this.authServers;
    }

    private AuthServer mapFromProperties(AuthServerConfigurationProperties.AuthServerProperties properties) {
        return new LoggingAuthServer(properties.getName(), properties.getIssUrl(), properties.getJwksUrl(), properties.getRefreshIntervalSeconds(), properties.getKeyCloakUrl());
    }

    @Generated
    public ConfigurationPropertiesAuthServerProvider(AuthServerConfigurationProperties authServerConfigurationProperties) {
        this.authServerConfigurationProperties = authServerConfigurationProperties;
    }
}

