/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.filter;

import com.nimbusds.jose.proc.BadJOSEException;
import de.adorsys.sts.token.authentication.TokenAuthenticationService;
import jakarta.annotation.Nonnull;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class JWTAuthenticationFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JWTAuthenticationFilter.class);
    private final TokenAuthenticationService tokenAuthenticationService;

    public void doFilterInternal(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain filterChain) throws ServletException, IOException {
        Authentication authentication;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"doFilter start");
        }
        if ((authentication = SecurityContextHolder.getContext().getAuthentication()) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Authentication is null. Try to get authentication from request...");
            }
            try {
                authentication = this.tokenAuthenticationService.getAuthentication(request);
            }
            catch (BadJOSEException e) {
                response.setHeader("X-B3-TraceId", request.getHeader("X-B3-TraceId"));
                response.setHeader("X-B3-SpanId", request.getHeader("X-B3-SpanId"));
                response.sendError(403, "Invalid token - Token expired");
            }
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"doFilter end");
        }
    }

    @Generated
    public JWTAuthenticationFilter(TokenAuthenticationService tokenAuthenticationService) {
        this.tokenAuthenticationService = tokenAuthenticationService;
    }
}

