/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.token.authentication;

import com.nimbusds.jose.jwk.JWK;
import de.adorsys.sts.tokenauth.AuthServer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingAuthServer
extends AuthServer {
    private static final Logger log = LoggerFactory.getLogger(LoggingAuthServer.class);

    public LoggingAuthServer(String name, String issUrl, String jwksUrl, int refreshIntervalSeconds, String keyCloakUrl) {
        super(name, issUrl, jwksUrl, refreshIntervalSeconds, keyCloakUrl);
    }

    protected void onJsonWebKeySetRetrieved(List<JWK> jwks) {
        super.onJsonWebKeySetRetrieved(jwks);
        if (log.isDebugEnabled()) {
            log.debug("Retrieved remote JWKS: {}", jwks);
        }
    }
}

