/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.secretserverclient;

import de.adorsys.sts.decryption.DecryptionConfiguration;
import de.adorsys.sts.keymanagement.service.DecryptionService;
import de.adorsys.sts.secret.CachingSecretServerClient;
import de.adorsys.sts.secret.LoggingSecretServerClient;
import de.adorsys.sts.secret.SecretServerClient;
import de.adorsys.sts.token.secretserver.TokenExchangeSecretServerClient;
import de.adorsys.sts.token.tokenexchange.TokenExchangeClient;
import de.adorsys.sts.token.tokenexchange.client.TokenExchangeClientConfiguration;
import de.adorsys.sts.tokenauth.BearerTokenValidator;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;

@Configuration
@ComponentScan(basePackages={"de.adorsys.sts.secretserverclient"})
@Import(value={TokenExchangeClientConfiguration.class, DecryptionConfiguration.class})
public class SecretServerClientConfiguration {
    @Bean
    public SecretServerClient secretServerClient(@Value(value="${sts.secret-server-client.audience}") String audience, @Value(value="${sts.secret-server-client.secret-server-uri}") String secretServerUri, TokenExchangeClient tokenExchangeClient, BearerTokenValidator bearerTokenValidator, DecryptionService decryptionService, @Value(value="${sts.secret-server-client.cache.enabled:false}") Boolean isCacheEnabled, @Value(value="${sts.secret-server-client.cache.maximum-size:1000}") Integer maximumSize, @Value(value="${sts.secret-server-client.cache.expire-after-access:10}") Integer expireAfterAccessInMinutes, CustomHeadersProperties customHeadersProperties) {
        TokenExchangeSecretServerClient secretServerClient = new TokenExchangeSecretServerClient(audience, secretServerUri, tokenExchangeClient, bearerTokenValidator, decryptionService, customHeadersProperties.getCustomHeaders());
        if (isCacheEnabled.booleanValue()) {
            secretServerClient = new CachingSecretServerClient((SecretServerClient)secretServerClient, maximumSize.intValue(), expireAfterAccessInMinutes.intValue());
        }
        return new LoggingSecretServerClient((SecretServerClient)secretServerClient);
    }

    @Component
    @ConfigurationProperties(prefix="sts.secret-server-client")
    public static class CustomHeadersProperties {
        private Map<String, String> customHeaders = new HashMap<String, String>();

        public Map<String, String> getCustomHeaders() {
            return this.customHeaders;
        }

        public void setCustomHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomHeadersProperties)) {
                return false;
            }
            CustomHeadersProperties other = (CustomHeadersProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, String> this$customHeaders = this.getCustomHeaders();
            Map<String, String> other$customHeaders = other.getCustomHeaders();
            return !(this$customHeaders == null ? other$customHeaders != null : !((Object)this$customHeaders).equals(other$customHeaders));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CustomHeadersProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $customHeaders = this.getCustomHeaders();
            result = result * 59 + ($customHeaders == null ? 43 : ((Object)$customHeaders).hashCode());
            return result;
        }

        public String toString() {
            return "SecretServerClientConfiguration.CustomHeadersProperties(customHeaders=" + this.getCustomHeaders() + ")";
        }
    }
}

