/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.secretserver.encryption;

import de.adorsys.sts.secret.Secret;
import de.adorsys.sts.secret.SecretEncryptionException;
import de.adorsys.sts.secret.SecretReadException;
import de.adorsys.sts.secret.SecretRepository;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class InMemorySecretRepository
implements SecretRepository {
    private final Map<String, Secret> secrets = new HashMap<String, Secret>();

    public Secret get(String subject) throws SecretEncryptionException {
        return this.secrets.get(subject);
    }

    public Optional<Secret> tryToGet(String subject) throws SecretReadException {
        Secret maybeSecret = this.secrets.get(subject);
        return Optional.ofNullable(maybeSecret);
    }

    public void save(String subject, Secret secret) {
        this.secrets.put(subject, secret);
    }
}

