/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement;

import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@ConfigurationProperties(prefix="sts.keymanagement")
@Validated
public class KeyManagementConfigurationProperties
implements KeyManagementProperties {
    @Valid
    @NotNull
    private KeyStoreConfigurationProperties keystore;

    @NotNull
    @Valid
    public KeyManagementProperties.KeyStoreProperties getKeystore() {
        return this.keystore;
    }

    public void setKeystore(KeyStoreConfigurationProperties keystore) {
        this.keystore = keystore;
    }

    @Validated
    public static class KeyStoreConfigurationProperties
    implements KeyManagementProperties.KeyStoreProperties {
        @NotNull
        @Size(min=1)
        private @NotNull @Size(min=1) String password;
        @NotNull
        @Size(min=1)
        private @NotNull @Size(min=1) String type;
        @NotNull
        @Size(min=1)
        private @NotNull @Size(min=1) String name;
        @NotNull
        @Size(min=1)
        private @NotNull @Size(min=1) String aliasPrefix;
        @Valid
        @NotNull
        private KeysConfigurationProperties keys;

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAliasPrefix() {
            return this.aliasPrefix;
        }

        public void setAliasPrefix(String aliasPrefix) {
            this.aliasPrefix = aliasPrefix;
        }

        public KeyManagementProperties.KeyStoreProperties.KeysProperties getKeys() {
            return this.keys;
        }

        public void setKeys(KeysConfigurationProperties keys) {
            this.keys = keys;
        }

        @Validated
        public static class KeysConfigurationProperties
        implements KeyManagementProperties.KeyStoreProperties.KeysProperties {
            @Valid
            @NotNull
            private KeyPairConfigurationProperties encKeyPairs;
            @Valid
            @NotNull
            private KeyPairConfigurationProperties signKeyPairs;
            @Valid
            @NotNull
            private SecretKeyConfigurationProperties secretKeys;

            public KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyPairProperties getEncKeyPairs() {
                return this.encKeyPairs;
            }

            public void setEncKeyPairs(KeyPairConfigurationProperties encKeyPairs) {
                this.encKeyPairs = encKeyPairs;
            }

            public KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyPairProperties getSignKeyPairs() {
                return this.signKeyPairs;
            }

            public void setSignKeyPairs(KeyPairConfigurationProperties signKeyPairs) {
                this.signKeyPairs = signKeyPairs;
            }

            public KeyManagementProperties.KeyStoreProperties.KeysProperties.SecretKeyProperties getSecretKeys() {
                return this.secretKeys;
            }

            public void setSecretKeys(SecretKeyConfigurationProperties secretKeys) {
                this.secretKeys = secretKeys;
            }

            @Validated
            public static class KeyPairConfigurationProperties
            implements KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyPairProperties {
                @Min(value=1L)
                private @Min(value=1L) Integer initialCount = 1;
                @NotNull
                @Size(min=1)
                private @NotNull @Size(min=1) String algo;
                @NotNull
                @Size(min=1)
                private @NotNull @Size(min=1) String sigAlgo;
                @NotNull
                @Min(value=1024L)
                private @NotNull @Min(value=1024L) Integer size;
                @NotNull
                @Size(min=1)
                private @NotNull @Size(min=1) String name;
                @NotNull
                @Min(value=1L)
                private @NotNull @Min(value=1L) Long validityInterval;
                @NotNull
                @Min(value=1L)
                private @NotNull @Min(value=1L) Long legacyInterval;

                public Integer getInitialCount() {
                    return this.initialCount;
                }

                public void setInitialCount(Integer initialCount) {
                    this.initialCount = initialCount;
                }

                public String getAlgo() {
                    return this.algo;
                }

                public void setAlgo(String algo) {
                    this.algo = algo;
                }

                public String getSigAlgo() {
                    return this.sigAlgo;
                }

                public void setSigAlgo(String sigAlgo) {
                    this.sigAlgo = sigAlgo;
                }

                public Integer getSize() {
                    return this.size;
                }

                public void setSize(Integer size) {
                    this.size = size;
                }

                public String getName() {
                    return this.name;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public Long getValidityInterval() {
                    return this.validityInterval;
                }

                public Long getLegacyInterval() {
                    return this.legacyInterval;
                }

                public void setValidityInterval(Long validityInterval) {
                    this.validityInterval = validityInterval;
                }

                public void setLegacyInterval(Long legacyInterval) {
                    this.legacyInterval = legacyInterval;
                }
            }

            @Validated
            public static class SecretKeyConfigurationProperties
            implements KeyManagementProperties.KeyStoreProperties.KeysProperties.SecretKeyProperties {
                @Min(value=1L)
                private @Min(value=1L) Integer initialCount = 1;
                @NotNull
                @Size(min=1)
                private @NotNull @Size(min=1) String algo;
                @NotNull
                private Integer size;
                @NotNull
                @Min(value=1L)
                private @NotNull @Min(value=1L) Long validityInterval;
                @NotNull
                @Min(value=1L)
                private @NotNull @Min(value=1L) Long legacyInterval;

                public Integer getInitialCount() {
                    return this.initialCount;
                }

                public void setInitialCount(Integer initialCount) {
                    this.initialCount = initialCount;
                }

                public String getAlgo() {
                    return this.algo;
                }

                public void setAlgo(String algo) {
                    this.algo = algo;
                }

                public Integer getSize() {
                    return this.size;
                }

                public void setSize(Integer size) {
                    this.size = size;
                }

                public Long getValidityInterval() {
                    return this.validityInterval;
                }

                public Long getLegacyInterval() {
                    return this.legacyInterval;
                }

                public void setValidityInterval(Long validityInterval) {
                    this.validityInterval = validityInterval;
                }

                public void setLegacyInterval(Long legacyInterval) {
                    this.legacyInterval = legacyInterval;
                }
            }
        }
    }
}

