/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.filter;

import de.adorsys.sts.token.authentication.TokenAuthenticationService;
import jakarta.annotation.Nonnull;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class JWTAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(JWTAuthenticationFilter.class);
    private final TokenAuthenticationService tokenAuthenticationService;

    public void doFilterInternal(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain filterChain) throws ServletException, IOException {
        Authentication authentication;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"doFilter start");
        }
        if ((authentication = SecurityContextHolder.getContext().getAuthentication()) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Authentication is null. Try to get authentication from request...");
            }
            authentication = this.tokenAuthenticationService.getAuthentication(request);
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"doFilter end");
        }
    }

    public JWTAuthenticationFilter(TokenAuthenticationService tokenAuthenticationService) {
        this.tokenAuthenticationService = tokenAuthenticationService;
    }
}

