/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializer;
import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.api.config.keystore.KeyStoreConfig;
import de.adorsys.keymanagement.api.metadata.KeyMetadataPersistence;
import de.adorsys.keymanagement.core.metadata.MetadataPersistenceConfig;
import de.adorsys.keymanagement.core.metadata.WithPersister;
import de.adorsys.keymanagement.juggler.services.DaggerBCJuggler;
import de.adorsys.sts.keymanagement.KeyManagementConfigurationProperties;
import de.adorsys.sts.keymanagement.model.StsKeyEntryImpl;
import de.adorsys.sts.keymanagement.persistence.CachedKeyStoreRepository;
import de.adorsys.sts.keymanagement.persistence.KeyStoreRepository;
import de.adorsys.sts.keymanagement.service.KeyConversionService;
import de.adorsys.sts.keymanagement.service.KeyConversionServiceImpl;
import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import de.adorsys.sts.keymanagement.service.KeyManagementService;
import de.adorsys.sts.keymanagement.service.KeyPairGenerator;
import de.adorsys.sts.keymanagement.service.KeyPairGeneratorImpl;
import de.adorsys.sts.keymanagement.service.KeyStoreGenerator;
import de.adorsys.sts.keymanagement.service.KeyStoreGeneratorImpl;
import de.adorsys.sts.keymanagement.service.KeyStoreInitializer;
import de.adorsys.sts.keymanagement.service.KeyStoreInitializerImpl;
import de.adorsys.sts.keymanagement.service.SecretKeyGenerator;
import de.adorsys.sts.keymanagement.service.SecretKeyGeneratorImpl;
import java.security.Provider;
import java.security.Security;
import java.time.Clock;
import java.time.ZonedDateTime;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;

@Configuration
@ComponentScan(basePackages={"de.adorsys.sts.keymanagement"}, excludeFilters={@ComponentScan.Filter(pattern={"de.adorsys.sts.keymanagement.bouncycastle.*"}, type=FilterType.REGEX)})
public class KeyManagementConfiguration {
    private static final Logger log = LoggerFactory.getLogger(KeyManagementConfiguration.class);

    @Bean
    KeyConversionService keyConversionService(KeyManagementConfigurationProperties keyManagementProperties) {
        KeyManagementProperties.KeyStoreProperties keystore = keyManagementProperties.getKeystore();
        return new KeyConversionServiceImpl(keystore.getPassword());
    }

    @Bean(name={"cached"})
    KeyStoreRepository cachedKeyStoreRepository(KeyStoreRepository keyStoreRepository) {
        log.debug("Creating 'cached' KeyStoreRepository bean...");
        return new CachedKeyStoreRepository(keyStoreRepository);
    }

    @Bean
    KeyManagementService keyManagerService(@Qualifier(value="cached") KeyStoreRepository keyStoreRepository, KeyConversionService keyConversionService) {
        return new KeyManagementService(keyStoreRepository, keyConversionService);
    }

    @Bean
    Clock clock() {
        return Clock.systemUTC();
    }

    @Bean
    KeyStoreGenerator keyStoreGenerator(Juggler juggler, Clock clock, @Qualifier(value="enc") KeyPairGenerator encKeyPairGenerator, @Qualifier(value="sign") KeyPairGenerator signKeyPairGenerator, SecretKeyGenerator secretKeyGenerator, KeyManagementConfigurationProperties keyManagementProperties) {
        return new KeyStoreGeneratorImpl(juggler, clock, encKeyPairGenerator, signKeyPairGenerator, secretKeyGenerator, (KeyManagementProperties)keyManagementProperties);
    }

    @Bean(name={"enc"})
    KeyPairGenerator encKeyPairGenerator(Juggler juggler, KeyManagementConfigurationProperties keyManagementProperties) {
        return new KeyPairGeneratorImpl(juggler, keyManagementProperties.getKeystore().getKeys().getEncKeyPairs());
    }

    @Bean(name={"sign"})
    KeyPairGenerator signKeyPairGenerator(Juggler juggler, KeyManagementConfigurationProperties keyManagementProperties) {
        return new KeyPairGeneratorImpl(juggler, keyManagementProperties.getKeystore().getKeys().getSignKeyPairs());
    }

    @Bean
    SecretKeyGenerator secretKeyGenerator(Juggler juggler, KeyManagementConfigurationProperties keyManagementProperties) {
        return new SecretKeyGeneratorImpl(juggler, keyManagementProperties.getKeystore().getKeys().getSecretKeys());
    }

    @Bean
    KeyStoreInitializer keyStoreInitializer(@Qualifier(value="cached") KeyStoreRepository keyStoreRepository, KeyStoreGenerator keyStoreGenerator) {
        return new KeyStoreInitializerImpl(keyStoreRepository, keyStoreGenerator);
    }

    @Bean
    Juggler juggler(KeyManagementProperties properties) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        String keyStoreType = properties.getKeystore().getType();
        return DaggerBCJuggler.builder().keyStoreConfig(KeyStoreConfig.builder().type(null == keyStoreType ? "UBER" : keyStoreType).build()).metadataConfig(MetadataPersistenceConfig.builder().metadataClass(StsKeyEntryImpl.class).gson(this.getGson()).build()).metadataPersister((KeyMetadataPersistence)new WithPersister()).build();
    }

    private Gson getGson() {
        return new GsonBuilder().registerTypeAdapter(ZonedDateTime.class, this.getZonedDateTimeJsonDeserializer()).registerTypeAdapter(ZonedDateTime.class, this.getZonedDateTimeJsonSerializer()).create();
    }

    private JsonDeserializer<ZonedDateTime> getZonedDateTimeJsonDeserializer() {
        return (json, type, jsonDeserializationContext) -> ZonedDateTime.parse(json.getAsJsonPrimitive().getAsString());
    }

    private JsonSerializer<ZonedDateTime> getZonedDateTimeJsonSerializer() {
        return (time, type, jsonDeserializationContext) -> new JsonPrimitive(time.toString());
    }
}

