/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.token.authentication;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.sts.token.authentication.AuthServerConfigurationProperties;
import de.adorsys.sts.token.authentication.LoggingAuthServer;
import de.adorsys.sts.tokenauth.AuthServer;
import de.adorsys.sts.tokenauth.AuthServersProvider;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationPropertiesAuthServerProvider
implements AuthServersProvider {
    private final AuthServerConfigurationProperties authServerConfigurationProperties;
    private final ObjectMapper objectMapper;
    private Map<String, AuthServer> authServers;

    @Autowired
    public ConfigurationPropertiesAuthServerProvider(AuthServerConfigurationProperties authServerConfigurationProperties, ObjectMapper objectMapper) {
        this.authServerConfigurationProperties = authServerConfigurationProperties;
        this.objectMapper = objectMapper;
    }

    public Map<String, AuthServer> getAll() {
        return this.getOrReadAuthServers();
    }

    public AuthServer get(String issuer) {
        return this.getOrReadAuthServers().get(issuer);
    }

    private Map<String, AuthServer> getOrReadAuthServers() {
        if (this.authServers == null) {
            List<AuthServerConfigurationProperties.AuthServerProperties> authServersProperties = this.authServerConfigurationProperties.getAuthservers();
            this.authServers = authServersProperties.stream().map(this::mapFromProperties).collect(Collectors.toMap(AuthServer::getIssUrl, Function.identity()));
        }
        return this.authServers;
    }

    private AuthServer mapFromProperties(AuthServerConfigurationProperties.AuthServerProperties properties) {
        return LoggingAuthServer.getInstance(properties.getName(), properties.getIssUrl(), properties.getJwksUrl(), properties.getRefreshIntervalSeconds());
    }
}

