package de.adorsys.sts.token.authentication;

import com.nimbusds.jose.jwk.JWK;
import de.adorsys.sts.tokenauth.AuthServer;

import java.util.List;

public class LoggingAuthServer extends AuthServer {
    private static LoggingAuthServer instance;

    private LoggingAuthServer(String name, String issUrl, String jwksUrl, int refreshIntervalSeconds) {
        super(name, issUrl, jwksUrl, refreshIntervalSeconds);
    }

    public static synchronized LoggingAuthServer getInstance(String name, String issUrl, String jwksUrl, int refreshIntervalSeconds) {
        if (instance == null) {
            instance = new LoggingAuthServer(name, issUrl, jwksUrl, refreshIntervalSeconds);
        }
        return instance;
    }

    @Override
    protected void onJsonWebKeySetRetrieved(List<JWK> jwks) {
        super.onJsonWebKeySetRetrieved(jwks);
    }
}

