/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.encryption;

import de.adorsys.sts.resourceserver.ResourceServerManagementConfiguration;
import de.adorsys.sts.resourceserver.ResourceServerManagementConfigurationProperties;
import de.adorsys.sts.resourceserver.service.CachingKeyRetrieverService;
import de.adorsys.sts.resourceserver.service.EncryptionService;
import de.adorsys.sts.resourceserver.service.JweEncryptionService;
import de.adorsys.sts.resourceserver.service.KeyRetrieverService;
import de.adorsys.sts.resourceserver.service.LoggingEncryptionService;
import de.adorsys.sts.resourceserver.service.LoggingKeyRetrieverService;
import de.adorsys.sts.resourceserver.service.RemoteKeyRetrieverService;
import de.adorsys.sts.resourceserver.service.ResourceServerManagementProperties;
import de.adorsys.sts.resourceserver.service.ResourceServerService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={ResourceServerManagementConfiguration.class})
public class EncryptionConfiguration {
    @Bean
    public KeyRetrieverService keyRetrieverService(ResourceServerService resourceServerService, ResourceServerManagementConfigurationProperties resourceServerManagementConfigurationProperties, @Value(value="${sts.resource-server-management.resource-retriever.cache.enabled:false}") Boolean isCacheEnabled, @Value(value="${sts.resource-server-management.resource-retriever.cache.maximum-size:1000}") Integer maximumSize, @Value(value="${sts.resource-server-management.resource-retriever.cache.expire-after-access:10}") Integer expireAfterAccessInMinutes) {
        RemoteKeyRetrieverService keyRetrieverService = new RemoteKeyRetrieverService(resourceServerService, (ResourceServerManagementProperties)resourceServerManagementConfigurationProperties);
        if (isCacheEnabled.booleanValue()) {
            keyRetrieverService = new CachingKeyRetrieverService((KeyRetrieverService)keyRetrieverService, maximumSize.intValue(), expireAfterAccessInMinutes.intValue());
        }
        return new LoggingKeyRetrieverService((KeyRetrieverService)keyRetrieverService);
    }

    @Bean
    public EncryptionService encryptionService(KeyRetrieverService keyRetrieverService) {
        JweEncryptionService encryptionService = new JweEncryptionService(keyRetrieverService);
        return new LoggingEncryptionService((EncryptionService)encryptionService);
    }
}

