/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.token.authentication.securitycontext;

import com.nimbusds.jwt.JWTClaimsSet;
import de.adorsys.sts.cryptoutils.ObjectMapperSPI;
import de.adorsys.sts.keymanagement.service.SecretProvider;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class SecurityContextSecretProvider
implements SecretProvider {
    private final String audience;
    private final String secretClaimPropertyKey;
    private final ObjectMapperSPI objectMapper;

    public SecurityContextSecretProvider(@Value(value="${sts.audience-name}") String audience, @Value(value="${sts.secret-claim-property-key}") String secretClaimPropertyKey, ObjectMapperSPI objectMapper) {
        this.audience = audience;
        this.objectMapper = objectMapper;
        this.secretClaimPropertyKey = secretClaimPropertyKey;
    }

    public String get() {
        Map secretClaims;
        JWTClaimsSet claimsSet = (JWTClaimsSet)SecurityContextHolder.getContext().getAuthentication().getCredentials();
        String secretClaimsAsText = (String)claimsSet.getClaim(this.secretClaimPropertyKey);
        try {
            secretClaims = this.objectMapper.readValue(secretClaimsAsText);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (String)secretClaims.get(this.audience);
    }
}

