/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.filter;

import de.adorsys.sts.token.authentication.TokenAuthenticationService;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class JWTAuthenticationFilter
extends GenericFilterBean {
    private static final Logger logger = LoggerFactory.getLogger(JWTAuthenticationFilter.class);
    private TokenAuthenticationService tokenAuthenticationService;

    public JWTAuthenticationFilter(TokenAuthenticationService tokenAuthenticationService) {
        this.tokenAuthenticationService = tokenAuthenticationService;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Authentication authentication;
        if (logger.isTraceEnabled()) {
            logger.trace("doFilter start");
        }
        if ((authentication = SecurityContextHolder.getContext().getAuthentication()) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Authentication is null. Try to get authentication from request...");
            }
            authentication = this.tokenAuthenticationService.getAuthentication((HttpServletRequest)request);
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        filterChain.doFilter(request, response);
        if (logger.isTraceEnabled()) {
            logger.trace("doFilter end");
        }
    }
}

