/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.token.authentication;

import com.nimbusds.jwt.JWTClaimsSet;
import de.adorsys.sts.token.authentication.BearerTokenAuthentication;
import de.adorsys.sts.tokenauth.BearerToken;
import de.adorsys.sts.tokenauth.BearerTokenValidator;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;

@Service
public class TokenAuthenticationService {
    private final Logger logger = LoggerFactory.getLogger(TokenAuthenticationService.class);
    private static final String TOKEN_PREFIX = "Bearer ";
    private static final String HEADER_KEY = "Authorization";
    private final BearerTokenValidator bearerTokenValidator;

    @Autowired
    public TokenAuthenticationService(BearerTokenValidator bearerTokenValidator) {
        this.bearerTokenValidator = bearerTokenValidator;
    }

    public Authentication getAuthentication(HttpServletRequest request) {
        String headerValue = request.getHeader(HEADER_KEY);
        if (StringUtils.isBlank((CharSequence)headerValue)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Header value '{}' is blank.", (Object)HEADER_KEY);
            }
            return null;
        }
        if (!StringUtils.startsWithIgnoreCase((CharSequence)headerValue, (CharSequence)TOKEN_PREFIX)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Header value does not start with '{}'.", (Object)TOKEN_PREFIX);
            }
            return null;
        }
        String strippedToken = StringUtils.substringAfterLast((String)headerValue, (String)" ");
        BearerToken bearerToken = this.bearerTokenValidator.extract(strippedToken);
        if (!bearerToken.isValid()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Token is not valid.");
            }
            return null;
        }
        JWTClaimsSet jwtClaimsSet = bearerToken.getClaims();
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        List roles = bearerToken.getRoles();
        if (roles != null) {
            for (String role : roles) {
                authorities.add(new SimpleGrantedAuthority(role));
            }
        }
        return new BearerTokenAuthentication(jwtClaimsSet.getSubject(), jwtClaimsSet, authorities, bearerToken.getToken());
    }
}

