/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.token.authentication;

import de.adorsys.sts.tokenauth.AuthServersProvider;
import de.adorsys.sts.tokenauth.BearerTokenValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingBearerTokenValidator
extends BearerTokenValidator {
    private final Logger logger = LoggerFactory.getLogger(LoggingBearerTokenValidator.class);

    public LoggingBearerTokenValidator(AuthServersProvider authServersProvider) {
        super(authServersProvider);
    }

    protected void onInvalidToken(String headerValue) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Token in header is invalid");
        }
    }

    protected void onTokenIsNull() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Token is null");
        }
    }

    protected void onAlgorithmIsNone(String token) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Token header alg is NONE");
        }
    }

    protected void onAuthServerIsNull(String token, String issuer) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Auth server with issuer {} for token not not allowed", (Object)issuer);
        }
    }

    protected void onErrorWhileExtractClaims(String token, Throwable e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Error occured while extracting claims from token", e);
        }
    }
}

