/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver;

import de.adorsys.sts.resourceserver.model.ResourceServer;
import de.adorsys.sts.resourceserver.service.ResourceServerManagementProperties;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@ConfigurationProperties(prefix="sts.resource-server-management")
@Validated
public class ResourceServerManagementConfigurationProperties
implements ResourceServerManagementProperties {
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) List<ResourceServer> resourceServers;
    @Valid
    @NotNull
    private ResourceRetrieverConfigurationProperties resourceRetriever;

    public List<ResourceServer> getResourceServers() {
        return this.resourceServers;
    }

    public ResourceServerManagementProperties.ResourceRetrieverProperties getResourceRetriever() {
        return this.resourceRetriever;
    }

    public void setResourceServers(List<ResourceServer> resourceServers) {
        this.resourceServers = resourceServers;
    }

    public void setResourceRetriever(ResourceRetrieverConfigurationProperties resourceRetriever) {
        this.resourceRetriever = resourceRetriever;
    }

    public static class ResourceRetrieverConfigurationProperties
    implements ResourceServerManagementProperties.ResourceRetrieverProperties {
        @Min(value=0L)
        @Max(value=0x7FFFFFFFL)
        private @Min(value=0L) @Max(value=0x7FFFFFFFL) Integer httpConnectTimeout;
        @Min(value=0L)
        @Max(value=0x7FFFFFFFL)
        private @Min(value=0L) @Max(value=0x7FFFFFFFL) Integer httpReadTimeout;
        @Min(value=0L)
        @Max(value=0x7FFFFFFFL)
        private @Min(value=0L) @Max(value=0x7FFFFFFFL) Integer httpSizeLimit;

        public Integer getHttpConnectTimeout() {
            return this.httpConnectTimeout;
        }

        public Integer getHttpReadTimeout() {
            return this.httpReadTimeout;
        }

        public Integer getHttpSizeLimit() {
            return this.httpSizeLimit;
        }

        public void setHttpConnectTimeout(Integer httpConnectTimeout) {
            this.httpConnectTimeout = httpConnectTimeout;
        }

        public void setHttpReadTimeout(Integer httpReadTimeout) {
            this.httpReadTimeout = httpReadTimeout;
        }

        public void setHttpSizeLimit(Integer httpSizeLimit) {
            this.httpSizeLimit = httpSizeLimit;
        }
    }
}

