/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.token.authentication;

import com.nimbusds.jwt.JWTClaimsSet;
import de.adorsys.sts.tokenauth.BearerToken;
import de.adorsys.sts.tokenauth.BearerTokenValidator;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;

@Service
public class TokenAuthenticationService {
    private final BearerTokenValidator bearerTokenValidator;

    @Autowired
    public TokenAuthenticationService(BearerTokenValidator bearerTokenValidator) {
        this.bearerTokenValidator = bearerTokenValidator;
    }

    public Authentication getAuthentication(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        BearerToken bearerToken = this.bearerTokenValidator.extract(token);
        if (!bearerToken.isValid()) {
            return null;
        }
        JWTClaimsSet jwtClaimsSet = bearerToken.getClaims();
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        List roles = bearerToken.getRoles();
        if (roles != null) {
            for (String role : roles) {
                authorities.add(new SimpleGrantedAuthority(role));
            }
        }
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)jwtClaimsSet.getSubject(), (Object)jwtClaimsSet, authorities);
        return authenticationToken;
    }
}

