/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver.persistence;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.sts.resourceserver.model.ResourceServer;
import de.adorsys.sts.resourceserver.persistence.ResourceServerRepository;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.adorsys.encobject.complextypes.BucketPath;
import org.adorsys.encobject.domain.ObjectHandle;
import org.adorsys.encobject.domain.Payload;
import org.adorsys.encobject.service.api.EncryptedPersistenceService;
import org.adorsys.encobject.service.api.EncryptionService;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.adorsys.encobject.service.api.KeySource;
import org.adorsys.encobject.service.impl.EncryptedPersistenceServiceImpl;
import org.adorsys.encobject.service.impl.JWEncryptionServiceImpl;
import org.adorsys.encobject.service.impl.KeyMapProviderBasedKeySourceImpl;
import org.adorsys.encobject.service.impl.SimplePayloadImpl;
import org.adorsys.encobject.types.KeyID;
import org.adorsys.envutils.EnvProperties;
import org.adorsys.jjwk.serverkey.ServerKeyMapProvider;
import org.apache.commons.lang3.StringUtils;

public class FsPersistenceResourceServerRepository
implements ResourceServerRepository {
    private static final TypeReference<List<ResourceServer>> RESOURCE_SERVER_LIST_TYPE = new TypeReference<List<ResourceServer>>(){};
    private static final String RESOURCE_SERVER_CONTAINER = "RESOURCE_SERVER_CONTAINER";
    private static final String RESOURCE_SERVERS_FILE_NAME = "resource_servers";
    private final ExtendedStoreConnection storeConnection;
    private final EncryptedPersistenceService encryptedPersistenceService;
    private final ServerKeyMapProvider keyMapProvider;
    private KeySource keySource;
    private String containerName;
    private ObjectMapper objectMapper = new ObjectMapper();

    public FsPersistenceResourceServerRepository(ExtendedStoreConnection storeConnection, ServerKeyMapProvider keyMapProvider) {
        this.storeConnection = storeConnection;
        this.keyMapProvider = keyMapProvider;
        this.keySource = new KeyMapProviderBasedKeySourceImpl(keyMapProvider);
        this.encryptedPersistenceService = new EncryptedPersistenceServiceImpl(this.storeConnection, (EncryptionService)new JWEncryptionServiceImpl());
    }

    @PostConstruct
    public void postConstruct() {
        this.containerName = EnvProperties.getEnvOrSysProp((String)RESOURCE_SERVER_CONTAINER, (String)"sts-rservers");
        if (!this.storeConnection.containerExists(this.containerName)) {
            this.storeConnection.createContainer(this.containerName);
        }
    }

    public List<ResourceServer> getAll() {
        return this.loadAll();
    }

    private List<ResourceServer> loadAll() {
        ObjectHandle handle = new ObjectHandle(this.containerName, RESOURCE_SERVERS_FILE_NAME);
        BucketPath bucketPath = BucketPath.fromHandle((ObjectHandle)handle);
        if (!this.storeConnection.blobExists(bucketPath)) {
            return Collections.emptyList();
        }
        Payload payload = this.encryptedPersistenceService.loadAndDecrypt(bucketPath, this.keySource);
        try {
            return (List)this.objectMapper.readValue(payload.getData(), RESOURCE_SERVER_LIST_TYPE);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void add(ResourceServer resourceServer) {
        if (!this.isValid(resourceServer)) {
            throw new RuntimeException("Resource server not valid");
        }
        List<ResourceServer> resourceServers = this.loadAll();
        this.add(resourceServer, resourceServers);
    }

    private Map<String, ResourceServer> mapResourceServers(List<ResourceServer> resourceServers) {
        return resourceServers.stream().collect(Collectors.toMap(ResourceServer::getAudience, Function.identity()));
    }

    private void add(ResourceServer resourceServer, List<ResourceServer> existingServers) {
        this.addInternal(resourceServer, existingServers);
        this.persist(existingServers);
    }

    private void addInternal(ResourceServer resourceServer, List<ResourceServer> existingServers) {
        String audience;
        Map<String, ResourceServer> resourceServerMap = this.mapResourceServers(existingServers);
        if (resourceServerMap.containsKey(audience = resourceServer.getAudience())) {
            ResourceServer existingResourceServer = resourceServerMap.get(audience);
            if (!existingResourceServer.equals((Object)resourceServer)) {
                int indexOf = existingServers.indexOf(existingResourceServer);
                existingServers.set(indexOf, resourceServer);
            }
        } else {
            existingServers.add(resourceServer);
        }
    }

    private void persist(List<ResourceServer> existingServers) {
        byte[] data;
        try {
            data = this.objectMapper.writeValueAsBytes(existingServers);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        ObjectHandle handle = new ObjectHandle(this.containerName, RESOURCE_SERVERS_FILE_NAME);
        BucketPath bucketPath = BucketPath.fromHandle((ObjectHandle)handle);
        KeyID keyID = new KeyID(this.keyMapProvider.randomSecretKey().jwk.getKeyID());
        this.encryptedPersistenceService.encryptAndPersist(bucketPath, (Payload)new SimplePayloadImpl(data), this.keySource, keyID);
    }

    public void addAll(Iterable<ResourceServer> serversIn) {
        List<ResourceServer> existingServers = this.loadAll();
        boolean persist = false;
        for (ResourceServer resourceServer : serversIn) {
            this.add(resourceServer, existingServers);
            persist = true;
        }
        if (persist) {
            this.persist(existingServers);
        }
    }

    private boolean isValid(ResourceServer resourceServer) {
        return !StringUtils.isBlank((CharSequence)resourceServer.getAudience());
    }
}

