/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keyrotation;

import de.adorsys.lockpersistence.client.LockClient;
import de.adorsys.sts.keymanagement.model.StsKeyStore;
import de.adorsys.sts.keymanagement.persistence.KeyStoreRepository;
import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import de.adorsys.sts.keymanagement.service.KeyRotationService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class KeyRotationSchedule {
    private static final Logger LOG = LoggerFactory.getLogger(KeyRotationSchedule.class);
    private final KeyRotationService keyRotationService;
    private final KeyStoreRepository keyStoreRepository;
    private final LockClient lockClient;
    private final String rotationLockName;

    @Autowired
    public KeyRotationSchedule(KeyRotationService keyRotationService, KeyStoreRepository keyStoreRepository, LockClient lockClient, KeyManagementProperties properties) {
        this.keyRotationService = keyRotationService;
        this.keyStoreRepository = keyStoreRepository;
        this.lockClient = lockClient;
        String keyStoreName = properties.getKeystore().getName();
        this.rotationLockName = "key-rotation -- " + keyStoreName;
    }

    @Scheduled(initialDelayString="${sts.keymanagement.rotation.checkInterval:60000}", fixedDelayString="${sts.keymanagement.rotation.checkInterval:60000}")
    public void scheduledRotation() {
        this.lockClient.executeIfOwned(this.rotationLockName, () -> {
            if (this.keyStoreRepository.exists()) {
                LOG.debug("Perform key rotation...");
                this.performKeyRotation();
                LOG.debug("Key rotation finished.");
            } else {
                LOG.debug("No key rotation needed. Keystore repository is (still) empty.");
            }
        });
    }

    private void performKeyRotation() {
        StsKeyStore keyStore = this.keyStoreRepository.load();
        KeyRotationService.KeyRotationResult keyRotationResult = this.keyRotationService.rotate(keyStore);
        if (LOG.isDebugEnabled()) {
            List removedKeys = keyRotationResult.getRemovedKeys();
            LOG.debug(removedKeys.size() + " keys removed: [" + removedKeys.stream().collect(Collectors.joining(",")) + "]");
            List futureKeys = keyRotationResult.getFutureKeys();
            LOG.debug(futureKeys.size() + " future keys generated: [" + futureKeys.stream().collect(Collectors.joining(",")) + "]");
            List generatedKeys = keyRotationResult.getGeneratedKeys();
            LOG.debug(generatedKeys.size() + " keys generated: [" + generatedKeys.stream().collect(Collectors.joining(",")) + "]");
        }
        this.keyStoreRepository.save(keyStore);
    }
}

